/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jdbc;

import java.sql.Connection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.mule.config.ExceptionHelper;
import org.mule.config.ExceptionReader;
import org.mule.config.i18n.CoreMessages;
import org.mule.providers.AbstractConnector;
import org.mule.providers.jdbc.NowPropertyExtractor;
import org.mule.providers.jdbc.SQLExceptionReader;
import org.mule.providers.jdbc.i18n.JdbcMessages;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.TransactionException;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOTransaction;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.util.ClassUtils;
import org.mule.util.ExceptionUtils;
import org.mule.util.properties.BeanPropertyExtractor;
import org.mule.util.properties.MapPropertyExtractor;
import org.mule.util.properties.MessagePropertyExtractor;
import org.mule.util.properties.PayloadPropertyExtractor;
import org.mule.util.properties.PropertyExtractor;

public class JdbcConnector
extends AbstractConnector {
    public static final String PROPERTY_POLLING_FREQUENCY = "pollingFrequency";
    public static final long DEFAULT_POLLING_FREQUENCY = 1000L;
    private static final String DEFAULT_QUERY_RUNNER = "org.apache.commons.dbutils.QueryRunner";
    private static final String DEFAULT_RESULTSET_HANDLER = "org.apache.commons.dbutils.handlers.MapListHandler";
    private static final Pattern STATEMENT_ARGS = Pattern.compile("\\$\\{[^\\}]*\\}");
    protected long pollingFrequency = 0L;
    protected DataSource dataSource;
    protected String dataSourceJndiName;
    protected Context jndiContext;
    protected String jndiInitialFactory;
    protected String jndiProviderUrl;
    protected Map providerProperties;
    protected Map queries;
    protected String resultSetHandler = "org.apache.commons.dbutils.handlers.MapListHandler";
    protected String queryRunner = "org.apache.commons.dbutils.QueryRunner";
    protected Set queryValueExtractors;
    protected Set propertyExtractors;

    protected void doInitialise() throws InitialisationException {
        try {
            if (this.dataSource == null) {
                this.initJndiContext();
                this.createDataSource();
            }
            if (this.queryValueExtractors == null) {
                this.queryValueExtractors = new HashSet();
                this.queryValueExtractors.add(MessagePropertyExtractor.class.getName());
                this.queryValueExtractors.add(NowPropertyExtractor.class.getName());
                this.queryValueExtractors.add(PayloadPropertyExtractor.class.getName());
                this.queryValueExtractors.add(MapPropertyExtractor.class.getName());
                this.queryValueExtractors.add(BeanPropertyExtractor.class.getName());
                if (ClassUtils.isClassOnPath((String)"org.mule.util.properties.Dom4jPropertyExtractor", ((Object)((Object)this)).getClass())) {
                    this.queryValueExtractors.add("org.mule.util.properties.Dom4jPropertyExtractor");
                }
                if (ClassUtils.isClassOnPath((String)"org.mule.util.properties.JDomPropertyExtractor", ((Object)((Object)this)).getClass())) {
                    this.queryValueExtractors.add("org.mule.util.properties.JDomPropertyExtractor");
                }
            }
            this.propertyExtractors = new HashSet();
            Iterator iterator = this.queryValueExtractors.iterator();
            while (iterator.hasNext()) {
                String s = (String)iterator.next();
                this.propertyExtractors.add(ClassUtils.instanciateClass((String)s, (Object[])ClassUtils.NO_ARGS));
            }
        }
        catch (Exception e) {
            throw new InitialisationException(CoreMessages.failedToCreate((String)"Jdbc Connector"), (Throwable)e, (Initialisable)this);
        }
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doStart() throws UMOException {
    }

    protected void doStop() throws UMOException {
    }

    public String getProtocol() {
        return "jdbc";
    }

    public UMOMessageReceiver createReceiver(UMOComponent component, UMOEndpoint endpoint) throws Exception {
        String tempPolling;
        Map props = endpoint.getProperties();
        if (props != null && (tempPolling = (String)props.get(PROPERTY_POLLING_FREQUENCY)) != null) {
            this.pollingFrequency = Long.parseLong(tempPolling);
        }
        if (this.pollingFrequency <= 0L) {
            this.pollingFrequency = 1000L;
        }
        Object[] params = this.getReadAndAckStatements((UMOImmutableEndpoint)endpoint);
        return this.getServiceDescriptor().createMessageReceiver((UMOConnector)this, component, endpoint, params);
    }

    protected void initJndiContext() throws NamingException {
        if (this.jndiContext == null) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            if (this.jndiInitialFactory != null) {
                props.put("java.naming.factory.initial", this.jndiInitialFactory);
            }
            if (this.jndiProviderUrl != null) {
                props.put("java.naming.provider.url", this.jndiProviderUrl);
            }
            if (this.providerProperties != null) {
                props.putAll(this.providerProperties);
            }
            this.jndiContext = new InitialContext(props);
        }
    }

    protected void createDataSource() throws InitialisationException, NamingException {
        Object temp = this.jndiContext.lookup(this.dataSourceJndiName);
        if (!(temp instanceof DataSource)) {
            throw new InitialisationException(JdbcMessages.jndiResourceNotFound(this.dataSourceJndiName), (Initialisable)this);
        }
        this.dataSource = (DataSource)temp;
    }

    public String[] getReadAndAckStatements(UMOImmutableEndpoint endpoint) {
        String ackStmt;
        String str = (String)endpoint.getProperty((Object)"sql");
        String readStmt = str != null ? str : endpoint.getEndpointURI().getAddress();
        str = (String)endpoint.getProperty((Object)"ack");
        if (str != null) {
            ackStmt = str;
            if ((str = this.getQuery(endpoint, ackStmt)) != null) {
                ackStmt = str;
            }
        } else {
            ackStmt = readStmt + ".ack";
            str = this.getQuery(endpoint, ackStmt);
            ackStmt = str != null ? str : null;
        }
        if ((str = this.getQuery(endpoint, readStmt)) != null) {
            readStmt = str;
        }
        if (readStmt == null) {
            throw new IllegalArgumentException("Read statement should not be null");
        }
        if (!"select".equalsIgnoreCase(readStmt.substring(0, 6))) {
            throw new IllegalArgumentException("Read statement should be a select sql statement");
        }
        if (!(ackStmt == null || "insert".equalsIgnoreCase(ackStmt.substring(0, 6)) || "update".equalsIgnoreCase(ackStmt.substring(0, 6)) || "delete".equalsIgnoreCase(ackStmt.substring(0, 6)))) {
            throw new IllegalArgumentException("Ack statement should be an insert / update / delete sql statement");
        }
        return new String[]{readStmt, ackStmt};
    }

    public String getQuery(UMOImmutableEndpoint endpoint, String stmt) {
        Object queries;
        Object query = null;
        if (endpoint != null && endpoint.getProperties() != null && (queries = endpoint.getProperties().get("queries")) instanceof Map) {
            query = ((Map)queries).get(stmt);
        }
        if (query == null && this.queries != null) {
            query = this.queries.get(stmt);
        }
        return query == null ? null : query.toString();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public long getPollingFrequency() {
        return this.pollingFrequency;
    }

    public void setPollingFrequency(long pollingFrequency) {
        this.pollingFrequency = pollingFrequency;
    }

    public Map getQueries() {
        return this.queries;
    }

    public void setQueries(Map queries) {
        this.queries = queries;
    }

    public String getDataSourceJndiName() {
        return this.dataSourceJndiName;
    }

    public void setDataSourceJndiName(String dataSourceJndiName) {
        this.dataSourceJndiName = dataSourceJndiName;
    }

    public Context getJndiContext() {
        return this.jndiContext;
    }

    public void setJndiContext(Context jndiContext) {
        this.jndiContext = jndiContext;
    }

    public String getJndiInitialFactory() {
        return this.jndiInitialFactory;
    }

    public void setJndiInitialFactory(String jndiInitialFactory) {
        this.jndiInitialFactory = jndiInitialFactory;
    }

    public String getJndiProviderUrl() {
        return this.jndiProviderUrl;
    }

    public void setJndiProviderUrl(String jndiProviderUrl) {
        this.jndiProviderUrl = jndiProviderUrl;
    }

    public Map getProviderProperties() {
        return this.providerProperties;
    }

    public void setProviderProperties(Map providerProperties) {
        this.providerProperties = providerProperties;
    }

    public Connection getConnection() throws Exception {
        UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
        if (tx != null && tx.hasResource((Object)this.dataSource)) {
            this.logger.debug((Object)"Retrieving connection from current transaction");
            return (Connection)tx.getResource((Object)this.dataSource);
        }
        this.logger.debug((Object)"Retrieving new connection from data source");
        Connection con = this.dataSource.getConnection();
        if (tx != null) {
            this.logger.debug((Object)"Binding connection to current transaction");
            try {
                tx.bindResource((Object)this.dataSource, (Object)con);
            }
            catch (TransactionException e) {
                throw new RuntimeException("Could not bind connection to current transaction", e);
            }
        }
        return con;
    }

    public String getResultSetHandler() {
        return this.resultSetHandler;
    }

    public void setResultSetHandler(String resultSetHandler) {
        this.resultSetHandler = resultSetHandler;
    }

    protected ResultSetHandler createResultSetHandler() {
        try {
            return (ResultSetHandler)ClassUtils.instanciateClass((String)this.getResultSetHandler(), (Object[])ClassUtils.NO_ARGS);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error creating instance of the resultSetHandler class :" + this.getResultSetHandler() + System.getProperty("line.separator") + ExceptionUtils.getFullStackTrace((Throwable)e));
        }
    }

    public Set getQueryValueExtractors() {
        return this.queryValueExtractors;
    }

    public void setQueryValueExtractors(Set queryValueExtractors) {
        this.queryValueExtractors = queryValueExtractors;
    }

    public String getQueryRunner() {
        return this.queryRunner;
    }

    public void setQueryRunner(String queryRunner) {
        this.queryRunner = queryRunner;
    }

    protected QueryRunner createQueryRunner() {
        try {
            return (QueryRunner)ClassUtils.instanciateClass((String)this.getQueryRunner(), (Object[])ClassUtils.NO_ARGS);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error creating instance of the queryRunner class :" + this.getQueryRunner() + System.getProperty("line.separator") + ExceptionUtils.getFullStackTrace((Throwable)e));
        }
    }

    public String parseStatement(String stmt, List params) {
        if (stmt == null) {
            return stmt;
        }
        Matcher m = STATEMENT_ARGS.matcher(stmt);
        StringBuffer sb = new StringBuffer(200);
        while (m.find()) {
            String key = m.group();
            m.appendReplacement(sb, "?");
            params.add(key);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public Object[] getParams(UMOImmutableEndpoint endpoint, List paramNames, Object message) throws Exception {
        Object[] params = new Object[paramNames.size()];
        for (int i = 0; i < paramNames.size(); ++i) {
            String param = (String)paramNames.get(i);
            String name = param.substring(2, param.length() - 1);
            Object value = null;
            boolean foundValue = false;
            if (message != null) {
                Iterator iterator = this.propertyExtractors.iterator();
                while (iterator.hasNext()) {
                    PropertyExtractor pe = (PropertyExtractor)iterator.next();
                    value = pe.getProperty(name, message);
                    if (value == null) continue;
                    if (value.equals("") && pe instanceof BeanPropertyExtractor) {
                        value = null;
                    }
                    foundValue = true;
                    break;
                }
            }
            if (!foundValue) {
                value = endpoint.getProperty((Object)name);
            }
            params[i] = value;
        }
        return params;
    }

    static {
        ExceptionHelper.registerExceptionReader((ExceptionReader)new SQLExceptionReader());
    }
}

