/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jdbc;

import java.sql.Connection;
import java.util.ArrayList;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.jdbc.JdbcConnector;
import org.mule.providers.jdbc.JdbcUtils;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOTransaction;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.util.StringUtils;

public class JdbcMessageDispatcher
extends AbstractMessageDispatcher {
    private JdbcConnector connector;

    public JdbcMessageDispatcher(UMOImmutableEndpoint endpoint) {
        super(endpoint);
        this.connector = (JdbcConnector)endpoint.getConnector();
    }

    protected void doDispose() {
    }

    protected void doDispatch(UMOEvent event) throws Exception {
        String writeStmt;
        UMOImmutableEndpoint endpoint;
        String str;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Dispatch event: " + event));
        }
        if ((str = this.connector.getQuery(endpoint = event.getEndpoint(), writeStmt = endpoint.getEndpointURI().getAddress())) != null) {
            writeStmt = str;
        }
        if (StringUtils.isBlank((String)(writeStmt = StringUtils.trimToEmpty((String)writeStmt)))) {
            throw new IllegalArgumentException("Missing a write statement");
        }
        if (!("insert".equalsIgnoreCase(writeStmt.substring(0, 6)) || "update".equalsIgnoreCase(writeStmt.substring(0, 6)) || "delete".equalsIgnoreCase(writeStmt.substring(0, 6)))) {
            throw new IllegalArgumentException("Write statement should be an insert / update / delete sql statement");
        }
        ArrayList paramNames = new ArrayList();
        writeStmt = this.connector.parseStatement(writeStmt, paramNames);
        Object[] paramValues = this.connector.getParams(endpoint, paramNames, new MuleMessage(event.getTransformedMessage()));
        UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
        Connection con = null;
        try {
            con = this.connector.getConnection();
            int nbRows = this.connector.createQueryRunner().update(con, writeStmt, paramValues);
            if (nbRows != 1) {
                this.logger.warn((Object)("Row count for write should be 1 and not " + nbRows));
            }
            if (tx == null) {
                JdbcUtils.commitAndClose(con);
            }
            this.logger.debug((Object)"Event dispatched succesfuly");
        }
        catch (Exception e) {
            this.logger.debug((Object)("Error dispatching event: " + e.getMessage()), (Throwable)e);
            if (tx == null) {
                JdbcUtils.rollbackAndClose(con);
            }
            throw e;
        }
    }

    protected UMOMessage doSend(UMOEvent event) throws Exception {
        this.doDispatch(event);
        return event.getMessage();
    }

    protected UMOMessage doReceive(long timeout) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Trying to receive a message with a timeout of " + timeout));
        }
        String[] stmts = this.connector.getReadAndAckStatements(this.endpoint);
        String readStmt = stmts[0];
        String ackStmt = stmts[1];
        ArrayList readParams = new ArrayList();
        ArrayList ackParams = new ArrayList();
        readStmt = this.connector.parseStatement(readStmt, readParams);
        ackStmt = this.connector.parseStatement(ackStmt, ackParams);
        Connection con = null;
        long t0 = System.currentTimeMillis();
        try {
            int nbRows;
            Object result;
            block9: {
                con = this.connector.getConnection();
                if (timeout < 0L) {
                    timeout = Long.MAX_VALUE;
                }
                while (true) {
                    if ((result = this.connector.createQueryRunner().query(con, readStmt, this.connector.getParams(this.endpoint, readParams, null), this.connector.createResultSetHandler())) != null) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Received: " + result));
                        }
                        break block9;
                    }
                    long sleep = Math.min(this.connector.getPollingFrequency(), timeout - (System.currentTimeMillis() - t0));
                    if (sleep <= 0L) break;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("No results, sleeping for " + sleep));
                    }
                    Thread.sleep(sleep);
                }
                this.logger.debug((Object)"Timeout");
                return null;
            }
            if (ackStmt != null && (nbRows = this.connector.createQueryRunner().update(con, ackStmt, this.connector.getParams(this.endpoint, ackParams, result))) != 1) {
                this.logger.warn((Object)("Row count for ack should be 1 and not " + nbRows));
            }
            UMOMessageAdapter msgAdapter = this.connector.getMessageAdapter(result);
            MuleMessage message = new MuleMessage((Object)msgAdapter);
            JdbcUtils.commitAndClose(con);
            return message;
        }
        catch (Exception e) {
            JdbcUtils.rollbackAndClose(con);
            throw e;
        }
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }
}

