/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jdbc;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.QueryRunner;
import org.mule.extras.client.MuleClient;
import org.mule.impl.MuleMessage;
import org.mule.providers.NullPayload;
import org.mule.providers.jdbc.JdbcConnector;
import org.mule.providers.jdbc.util.MuleDerbyUtils;
import org.mule.tck.FunctionalTestCase;
import org.mule.umo.UMOMessage;

public class JdbcSelectOnOutboundFunctionalTestCase
extends FunctionalTestCase {
    private static final String[] TEST_VALUES = new String[]{"Test", "The Moon", "Terra"};

    protected String getConfigResources() {
        return "jdbc-select-outbound.xml";
    }

    protected void doSetUp() throws Exception {
        int updated;
        super.doSetUp();
        JdbcConnector jdbcConnector = (JdbcConnector)managementContext.getRegistry().lookupConnector("jdbcConnector");
        QueryRunner qr = jdbcConnector.createQueryRunner();
        try {
            updated = qr.update(jdbcConnector.getConnection(), "DELETE FROM TEST");
            this.logger.debug((Object)(updated + " rows deleted"));
        }
        catch (Exception e) {
            qr.update(jdbcConnector.getConnection(), "CREATE TABLE TEST(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0)  NOT NULL PRIMARY KEY,TYPE INTEGER,DATA VARCHAR(255),ACK TIMESTAMP,RESULT VARCHAR(255))");
            this.logger.debug((Object)"Table created");
        }
        updated = qr.update(jdbcConnector.getConnection(), "INSERT INTO TEST(TYPE, DATA) VALUES (1, '" + TEST_VALUES[0] + "')");
        this.logger.debug((Object)(updated + " rows updated"));
        updated = qr.update(jdbcConnector.getConnection(), "INSERT INTO TEST(TYPE, DATA) VALUES (2, '" + TEST_VALUES[1] + "')");
        this.logger.debug((Object)(updated + " rows updated"));
        updated = qr.update(jdbcConnector.getConnection(), "INSERT INTO TEST(TYPE, DATA) VALUES (3, '" + TEST_VALUES[2] + "')");
        this.logger.debug((Object)(updated + " rows updated"));
    }

    protected void doTearDown() throws Exception {
        JdbcConnector jdbcConnector = (JdbcConnector)managementContext.getRegistry().lookupConnector("jdbcConnector");
        QueryRunner qr = jdbcConnector.createQueryRunner();
        int updated = qr.update(jdbcConnector.getConnection(), "DELETE FROM TEST");
        this.logger.debug((Object)(updated + " rows deleted"));
        super.doTearDown();
    }

    protected void suitePreSetUp() throws Exception {
        MuleDerbyUtils.defaultDerbyCleanAndInit((String)"derby.properties", (String)"database.name");
        super.suitePreSetUp();
    }

    public void testSelectOnOutbound() throws Exception {
        MuleClient client = new MuleClient();
        UMOMessage reply = client.send("vm://jdbc.test", (UMOMessage)new MuleMessage((Object)NullPayload.getInstance()));
        JdbcSelectOnOutboundFunctionalTestCase.assertNotNull((Object)reply.getPayload());
        JdbcSelectOnOutboundFunctionalTestCase.assertTrue((boolean)(reply.getPayload() instanceof List));
        List resultList = (List)reply.getPayload();
        JdbcSelectOnOutboundFunctionalTestCase.assertTrue((resultList.size() == 1 ? 1 : 0) != 0);
        JdbcSelectOnOutboundFunctionalTestCase.assertTrue((boolean)(resultList.get(0) instanceof Map));
        Map resultMap = (Map)resultList.get(0);
        JdbcSelectOnOutboundFunctionalTestCase.assertEquals((Object)new Integer(1), resultMap.get("TYPE"));
        JdbcSelectOnOutboundFunctionalTestCase.assertEquals((Object)TEST_VALUES[0], resultMap.get("DATA"));
    }

    public void testSelectOnOutboundByPropertyExtractor() throws Exception {
        MuleClient client = new MuleClient();
        MyMessage payload = new MyMessage(2);
        UMOMessage reply = client.send("vm://terra", (UMOMessage)new MuleMessage((Object)payload));
        JdbcSelectOnOutboundFunctionalTestCase.assertNotNull((Object)reply.getPayload());
        JdbcSelectOnOutboundFunctionalTestCase.assertTrue((boolean)(reply.getPayload() instanceof List));
        List resultList = (List)reply.getPayload();
        this.logger.debug((Object)("resultList.size() " + resultList.size()));
        JdbcSelectOnOutboundFunctionalTestCase.assertTrue((resultList.size() == 1 ? 1 : 0) != 0);
        JdbcSelectOnOutboundFunctionalTestCase.assertTrue((boolean)(resultList.get(0) instanceof Map));
        Map resultMap = (Map)resultList.get(0);
        JdbcSelectOnOutboundFunctionalTestCase.assertEquals((Object)new Integer(2), resultMap.get("TYPE"));
        JdbcSelectOnOutboundFunctionalTestCase.assertEquals((Object)TEST_VALUES[1], resultMap.get("DATA"));
    }

    public static class MyMessage
    implements Serializable {
        private int type;

        public MyMessage(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }
    }
}

