/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jdbc.config;

import org.mule.providers.jdbc.JdbcConnector;
import org.mule.providers.jdbc.test.TestDataSource;
import org.mule.tck.FunctionalTestCase;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.util.object.ObjectFactory;

public class JdbcNamespaceHandlerTestCase
extends FunctionalTestCase {
    protected String getConfigResources() {
        return "jdbc-namespace-config.xml";
    }

    public void testWithDataSource() throws Exception {
        JdbcConnector c = (JdbcConnector)managementContext.getRegistry().lookupConnector("jdbcConnector1");
        JdbcNamespaceHandlerTestCase.assertNotNull((Object)c);
        ObjectFactory dsf = c.getDataSourceFactory();
        JdbcNamespaceHandlerTestCase.assertNotNull((Object)dsf);
        Object ds = dsf.getOrCreate();
        JdbcNamespaceHandlerTestCase.assertNotNull((Object)ds);
        JdbcNamespaceHandlerTestCase.assertEquals((Object)TestDataSource.class, ds.getClass());
        JdbcNamespaceHandlerTestCase.assertNull((Object)c.getQueries());
    }

    public void testWithDataSourceViaJndi() throws Exception {
        JdbcConnector c = (JdbcConnector)managementContext.getRegistry().lookupConnector("jdbcConnector2");
        JdbcNamespaceHandlerTestCase.assertNotNull((Object)c);
        ObjectFactory dsf = c.getDataSourceFactory();
        JdbcNamespaceHandlerTestCase.assertNotNull((Object)dsf);
        Object ds = dsf.getOrCreate();
        JdbcNamespaceHandlerTestCase.assertNotNull((Object)ds);
        JdbcNamespaceHandlerTestCase.assertEquals((Object)TestDataSource.class, ds.getClass());
        JdbcNamespaceHandlerTestCase.assertNull((Object)c.getQueries());
        JdbcNamespaceHandlerTestCase.assertTrue((boolean)c.isConnected());
        JdbcNamespaceHandlerTestCase.assertTrue((boolean)c.isStarted());
    }

    public void testFullyConfigured() throws Exception {
        JdbcConnector c = (JdbcConnector)managementContext.getRegistry().lookupConnector("jdbcConnector3");
        JdbcNamespaceHandlerTestCase.assertNotNull((Object)c);
        ObjectFactory dsf = c.getDataSourceFactory();
        JdbcNamespaceHandlerTestCase.assertNotNull((Object)dsf);
        Object ds = dsf.getOrCreate();
        JdbcNamespaceHandlerTestCase.assertNotNull((Object)ds);
        JdbcNamespaceHandlerTestCase.assertEquals((Object)TestDataSource.class, ds.getClass());
        JdbcNamespaceHandlerTestCase.assertNotNull((Object)c.getQueries());
        JdbcNamespaceHandlerTestCase.assertEquals((int)3, (int)c.getQueries().size());
        JdbcNamespaceHandlerTestCase.assertTrue((boolean)c.isConnected());
        JdbcNamespaceHandlerTestCase.assertTrue((boolean)c.isStarted());
    }

    public void testEndpointQueryOverride() throws Exception {
        JdbcConnector c = (JdbcConnector)managementContext.getRegistry().lookupConnector("jdbcConnector3");
        UMOImmutableEndpoint testJdbcEndpoint = managementContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("testJdbcEndpoint");
        JdbcNamespaceHandlerTestCase.assertNotNull((Object)c.getQuery(testJdbcEndpoint, "getTest"));
        JdbcNamespaceHandlerTestCase.assertNotNull((Object)c.getQuery(testJdbcEndpoint, "getTest2"));
        JdbcNamespaceHandlerTestCase.assertEquals((String)"OVERRIDDEN VALUE", (String)c.getQuery(testJdbcEndpoint, "getTest2"));
        JdbcNamespaceHandlerTestCase.assertNotNull((Object)c.getQuery(testJdbcEndpoint, "getTest3"));
        JdbcNamespaceHandlerTestCase.assertNull((Object)c.getQuery(testJdbcEndpoint, "getTest4"));
    }
}

