/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jdbc;

import java.sql.Connection;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.jdbc.JdbcConnector;
import org.mule.providers.jdbc.JdbcUtils;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOTransaction;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.util.StringUtils;

public class JdbcMessageDispatcher
extends AbstractMessageDispatcher {
    private static Log staticLogger = LogFactory.getLog((Class)AbstractMessageDispatcher.class);
    private JdbcConnector connector;
    private static final String STORED_PROCEDURE_PREFIX = "{ ";
    private static final String STORED_PROCEDURE_SUFFIX = " }";

    public JdbcMessageDispatcher(UMOImmutableEndpoint endpoint) {
        super(endpoint);
        this.connector = (JdbcConnector)endpoint.getConnector();
    }

    protected void doDispose() {
    }

    protected void executeWriteStatement(UMOEvent event, String writeStmt) throws Exception {
        ArrayList paramNames = new ArrayList();
        writeStmt = this.connector.parseStatement(writeStmt, paramNames);
        Object[] paramValues = this.connector.getParams(this.endpoint, paramNames, new MuleMessage(event.getTransformedMessage()), this.endpoint.getEndpointURI().getAddress());
        UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
        Connection con = null;
        try {
            int nbRows;
            con = this.connector.getConnection();
            if ("call".equalsIgnoreCase(writeStmt.substring(0, 4))) {
                writeStmt = STORED_PROCEDURE_PREFIX + writeStmt + STORED_PROCEDURE_SUFFIX;
            }
            if ((nbRows = this.connector.createQueryRunner().update(con, writeStmt, paramValues)) != 1) {
                this.logger.warn((Object)("Row count for write should be 1 and not " + nbRows));
            }
            if (tx == null) {
                JdbcUtils.commitAndClose(con);
            }
            this.logger.debug((Object)"Event dispatched succesfuly");
        }
        catch (Exception e) {
            this.logger.debug((Object)("Error dispatching event: " + e.getMessage()), (Throwable)e);
            if (tx == null) {
                JdbcUtils.rollbackAndClose(con);
            }
            throw e;
        }
    }

    protected String getStatement(UMOImmutableEndpoint endpoint) {
        String writeStmt = endpoint.getEndpointURI().getAddress();
        String str = this.connector.getQuery(endpoint, writeStmt);
        if (str != null) {
            writeStmt = str;
        }
        if (StringUtils.isBlank((String)(writeStmt = StringUtils.trimToEmpty((String)writeStmt)))) {
            throw new IllegalArgumentException("Missing statement");
        }
        return writeStmt;
    }

    protected boolean isWriteStatement(String writeStmt) {
        return "insert".equalsIgnoreCase(writeStmt.substring(0, 6)) || "update".equalsIgnoreCase(writeStmt.substring(0, 6)) || "delete".equalsIgnoreCase(writeStmt.substring(0, 6)) || "merge".equalsIgnoreCase(writeStmt.substring(0, 5)) || "call".equalsIgnoreCase(writeStmt.substring(0, 4));
    }

    protected void doDispatch(UMOEvent event) throws Exception {
        String writeStmt;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Dispatch event: " + event));
        }
        if (!this.isWriteStatement(writeStmt = this.getStatement(event.getEndpoint()))) {
            throw new IllegalArgumentException("Write statement should be an insert / update / delete / merge sql statement, or a stored-procedure call");
        }
        this.executeWriteStatement(event, writeStmt);
    }

    protected UMOMessage doSend(UMOEvent event) throws Exception {
        String statement = this.getStatement(event.getEndpoint());
        if (this.isWriteStatement(statement)) {
            this.executeWriteStatement(event, statement);
            return event.getMessage();
        }
        return JdbcMessageDispatcher.executeRequest(event.getTimeout(), event, this.connector, this.endpoint);
    }

    protected static UMOMessage executeRequest(long timeout, UMOEvent event, JdbcConnector connector, UMOImmutableEndpoint endpoint) throws Exception {
        if (staticLogger.isDebugEnabled()) {
            staticLogger.debug((Object)("Trying to receive a message with a timeout of " + timeout));
        }
        String[] stmts = connector.getReadAndAckStatements(endpoint);
        String readStmt = stmts[0];
        String ackStmt = stmts[1];
        ArrayList readParams = new ArrayList();
        ArrayList ackParams = new ArrayList();
        readStmt = connector.parseStatement(readStmt, readParams);
        ackStmt = connector.parseStatement(ackStmt, ackParams);
        Connection con = null;
        long t0 = System.currentTimeMillis();
        try {
            int nbRows;
            Object result;
            block9: {
                con = connector.getConnection();
                if (timeout < 0L) {
                    timeout = Long.MAX_VALUE;
                }
                while (true) {
                    if ((result = connector.createQueryRunner().query(con, readStmt, connector.getParams(endpoint, readParams, event != null ? event.getMessage() : null, endpoint.getEndpointURI().getAddress()), connector.createResultSetHandler())) != null) {
                        if (staticLogger.isDebugEnabled()) {
                            staticLogger.debug((Object)("Received: " + result));
                        }
                        break block9;
                    }
                    long sleep = Math.min(connector.getPollingFrequency(), timeout - (System.currentTimeMillis() - t0));
                    if (sleep <= 0L) break;
                    if (staticLogger.isDebugEnabled()) {
                        staticLogger.debug((Object)("No results, sleeping for " + sleep));
                    }
                    Thread.sleep(sleep);
                }
                staticLogger.debug((Object)"Timeout");
                return null;
            }
            if (ackStmt != null && (nbRows = connector.createQueryRunner().update(con, ackStmt, connector.getParams(endpoint, ackParams, result, ackStmt))) != 1) {
                staticLogger.warn((Object)("Row count for ack should be 1 and not " + nbRows));
            }
            UMOMessageAdapter msgAdapter = connector.getMessageAdapter(result);
            MuleMessage message = new MuleMessage((Object)msgAdapter);
            JdbcUtils.commitAndClose(con);
            return message;
        }
        catch (Exception e) {
            JdbcUtils.rollbackAndClose(con);
            throw e;
        }
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }
}

