/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.mule.impl.MuleMessage;
import org.mule.providers.ConnectException;
import org.mule.providers.TransactedPollingMessageReceiver;
import org.mule.providers.jdbc.JdbcConnector;
import org.mule.providers.jdbc.JdbcUtils;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOTransaction;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.CreateException;
import org.mule.umo.provider.UMOConnectable;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;

public class JdbcMessageReceiver
extends TransactedPollingMessageReceiver {
    protected JdbcConnector connector;
    protected String readStmt;
    protected String ackStmt;
    protected List readParams;
    protected List ackParams;

    public JdbcMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint, String readStmt, String ackStmt) throws CreateException {
        super(connector, component, (UMOImmutableEndpoint)endpoint);
        this.setFrequency(((JdbcConnector)connector).getPollingFrequency());
        this.setReceiveMessagesInTransaction(false);
        this.connector = (JdbcConnector)connector;
        this.readParams = new ArrayList();
        this.readStmt = this.connector.parseStatement(readStmt, this.readParams);
        this.ackParams = new ArrayList();
        this.ackStmt = this.connector.parseStatement(ackStmt, this.ackParams);
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
        Connection con = null;
        try {
            con = this.connector.getConnection();
        }
        catch (Exception e) {
            throw new ConnectException((Throwable)e, (UMOConnectable)this);
        }
        finally {
            JdbcUtils.close(con);
        }
    }

    protected void doDisconnect() throws ConnectException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processMessage(Object message) throws Exception {
        Connection con = null;
        UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
        try {
            try {
                con = this.connector.getConnection();
                UMOMessageAdapter msgAdapter = this.connector.getMessageAdapter(message);
                MuleMessage umoMessage = new MuleMessage((Object)msgAdapter);
                if (this.ackStmt != null) {
                    Object[] ackParams = this.connector.getParams(this.endpoint, this.ackParams, umoMessage, this.endpoint.getEndpointURI().getAddress());
                    int nbRows = this.connector.createQueryRunner().update(con, this.ackStmt, ackParams);
                    if (nbRows != 1) {
                        this.logger.warn((Object)("Row count for ack should be 1 and not " + nbRows));
                    }
                }
                this.routeMessage((UMOMessage)umoMessage, tx, tx != null || this.endpoint.isSynchronous());
            }
            catch (Exception ex) {
                if (tx == null) throw ex;
                tx.setRollbackOnly();
                throw ex;
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (this.endpoint.getManagementContext().getTransactionManager() == null) {
                if (tx != null) throw throwable;
            }
            JdbcUtils.close(con);
            throw throwable;
        }
        if (this.endpoint.getManagementContext().getTransactionManager() == null) {
            if (tx != null) return;
        }
        JdbcUtils.close(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMessages() throws Exception {
        List list;
        Connection con = null;
        try {
            try {
                con = this.connector.getConnection();
            }
            catch (SQLException e) {
                throw new ConnectException((Throwable)e, (UMOConnectable)this);
            }
            Object[] readParams = this.connector.getParams(this.endpoint, this.readParams, null, this.endpoint.getEndpointURI().getAddress());
            Object results = this.connector.createQueryRunner().query(con, this.readStmt, readParams, this.connector.createResultSetHandler());
            list = (List)results;
        }
        catch (Throwable throwable) {
            JdbcUtils.close(con);
            throw throwable;
        }
        JdbcUtils.close(con);
        return list;
    }
}

