/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jdbc;

import java.sql.Connection;
import java.sql.SQLException;

public abstract class JdbcUtils {
    protected JdbcUtils() {
    }

    public static void close(Connection con) throws SQLException {
        if (con != null && !con.isClosed()) {
            con.close();
        }
    }

    public static void commitAndClose(Connection con) throws SQLException {
        if (con != null) {
            if (!con.getAutoCommit()) {
                con.commit();
            }
            con.close();
        }
    }

    public static void rollbackAndClose(Connection con) throws SQLException {
        if (con != null) {
            if (!con.getAutoCommit()) {
                con.rollback();
            }
            con.close();
        }
    }
}

