/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jdbc.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.mule.util.ClassUtils;
import org.mule.util.FileUtils;

public class MuleDerbyUtils {
    private static final String DERBY_DRIVER_CLASS = "org.apache.derby.jdbc.EmbeddedDriver";

    private MuleDerbyUtils() {
    }

    public static String setDerbyHome() {
        return MuleDerbyUtils.setDerbyHome("target");
    }

    public static String setDerbyHome(String path) {
        File derbySystemHome = new File(System.getProperty("user.dir"), path);
        System.setProperty("derby.system.home", derbySystemHome.getAbsolutePath());
        return derbySystemHome.getAbsolutePath();
    }

    public static void stopDatabase() throws SQLException {
        try {
            ClassUtils.instanciateClass((String)DERBY_DRIVER_CLASS, (Object[])new Object[0]);
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
        }
        catch (SQLException sqlex) {
            if (!"XJ015".equals(sqlex.getSQLState())) {
                throw sqlex;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void cleanupDerbyDb(String derbySystemHome, String databaseName) throws IOException, SQLException {
        MuleDerbyUtils.stopDatabase();
        FileUtils.deleteTree((File)new File(derbySystemHome + File.separator + databaseName));
    }

    public static void createDataBase(String databaseName) throws SQLException {
        try {
            Driver derbyDriver = (Driver)ClassUtils.instanciateClass((String)DERBY_DRIVER_CLASS, (Object[])new Object[0]);
            Method connectMethod = derbyDriver.getClass().getMethod("connect", String.class, Properties.class);
            String connectionName = "jdbc:derby:" + databaseName + ";create=true";
            connectMethod.invoke((Object)derbyDriver, connectionName, null);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error creating the database " + databaseName, ex);
        }
    }

    public static String loadDatabaseName(String propertiesLocation, String propertyName) throws IOException {
        Properties derbyProperties = new Properties();
        URL resource = ClassUtils.getResource((String)propertiesLocation, (Class)MuleDerbyUtils.class);
        derbyProperties.load(resource.openStream());
        return derbyProperties.getProperty(propertyName);
    }

    public static void defaultDerbyCleanAndInit(String propertiesLocation, String propertyName) throws IOException, SQLException {
        String derbyHome = MuleDerbyUtils.setDerbyHome();
        String dbName = MuleDerbyUtils.loadDatabaseName(propertiesLocation, propertyName);
        MuleDerbyUtils.cleanupDerbyDb(derbyHome, dbName);
        MuleDerbyUtils.createDataBase(dbName);
    }
}

