/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.config;

import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.tck.FunctionalTestCase;
import org.mule.transport.jdbc.JdbcConnector;
import org.mule.transport.jdbc.test.TestDataSource;

public class JdbcNamespaceHandlerTestCase
extends FunctionalTestCase {
    protected String getConfigResources() {
        return "jdbc-namespace-config.xml";
    }

    public void testWithDataSource() throws Exception {
        JdbcConnector c = (JdbcConnector)muleContext.getRegistry().lookupConnector("jdbcConnector1");
        JdbcNamespaceHandlerTestCase.assertNotNull((Object)c);
        JdbcNamespaceHandlerTestCase.assertTrue((boolean)(c.getDataSource() instanceof TestDataSource));
        JdbcNamespaceHandlerTestCase.assertNull((Object)c.getQueries());
    }

    public void testWithDataSourceViaJndi() throws Exception {
        JdbcConnector c = (JdbcConnector)muleContext.getRegistry().lookupConnector("jdbcConnector2");
        JdbcNamespaceHandlerTestCase.assertNotNull((Object)c);
        JdbcNamespaceHandlerTestCase.assertTrue((boolean)(c.getDataSource() instanceof TestDataSource));
        JdbcNamespaceHandlerTestCase.assertNull((Object)c.getQueries());
        JdbcNamespaceHandlerTestCase.assertTrue((boolean)c.isConnected());
        JdbcNamespaceHandlerTestCase.assertTrue((boolean)c.isStarted());
    }

    public void testFullyConfigured() throws Exception {
        JdbcConnector c = (JdbcConnector)muleContext.getRegistry().lookupConnector("jdbcConnector3");
        JdbcNamespaceHandlerTestCase.assertNotNull((Object)c);
        JdbcNamespaceHandlerTestCase.assertTrue((boolean)(c.getDataSource() instanceof TestDataSource));
        JdbcNamespaceHandlerTestCase.assertNotNull((Object)c.getQueries());
        JdbcNamespaceHandlerTestCase.assertEquals((int)3, (int)c.getQueries().size());
        JdbcNamespaceHandlerTestCase.assertTrue((boolean)c.isConnected());
        JdbcNamespaceHandlerTestCase.assertTrue((boolean)c.isStarted());
    }

    public void testEndpointQueryOverride() throws Exception {
        JdbcConnector c = (JdbcConnector)muleContext.getRegistry().lookupConnector("jdbcConnector3");
        ImmutableEndpoint testJdbcEndpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("testJdbcEndpoint");
        JdbcNamespaceHandlerTestCase.assertNotNull((Object)c.getQuery(testJdbcEndpoint, "getTest"));
        JdbcNamespaceHandlerTestCase.assertNotNull((Object)c.getQuery(testJdbcEndpoint, "getTest2"));
        JdbcNamespaceHandlerTestCase.assertEquals((String)"OVERRIDDEN VALUE", (String)c.getQuery(testJdbcEndpoint, "getTest2"));
        JdbcNamespaceHandlerTestCase.assertNotNull((Object)c.getQuery(testJdbcEndpoint, "getTest3"));
        JdbcNamespaceHandlerTestCase.assertNull((Object)c.getQuery(testJdbcEndpoint, "getTest4"));
    }
}

