/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc;

import java.sql.Connection;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transaction.Transaction;
import org.mule.api.transport.MessageAdapter;
import org.mule.transaction.TransactionCoordination;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.jdbc.JdbcConnector;
import org.mule.transport.jdbc.JdbcUtils;
import org.mule.util.ArrayUtils;
import org.mule.util.StringUtils;

public class JdbcMessageDispatcher
extends AbstractMessageDispatcher {
    private static Log staticLogger = LogFactory.getLog(AbstractMessageDispatcher.class);
    private JdbcConnector connector;
    private static final String STORED_PROCEDURE_PREFIX = "{ ";
    private static final String STORED_PROCEDURE_SUFFIX = " }";

    public JdbcMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (JdbcConnector)endpoint.getConnector();
    }

    protected void doDispose() {
    }

    protected void executeWriteStatement(MuleEvent event, String writeStmt) throws Exception {
        ArrayList paramNames = new ArrayList();
        writeStmt = this.connector.parseStatement(writeStmt, paramNames);
        Object[] paramValues = this.connector.getParams(this.endpoint, paramNames, new DefaultMuleMessage(event.transformMessage()), this.endpoint.getEndpointURI().getAddress());
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        Connection con = null;
        try {
            int nbRows;
            con = this.connector.getConnection();
            if ("call".equalsIgnoreCase(writeStmt.substring(0, 4))) {
                writeStmt = STORED_PROCEDURE_PREFIX + writeStmt + STORED_PROCEDURE_SUFFIX;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("SQL UPDATE: " + writeStmt + ", params = " + ArrayUtils.toString((Object)paramValues)));
            }
            if ((nbRows = this.connector.getQueryRunner().update(con, writeStmt, paramValues)) != 1) {
                this.logger.warn((Object)("Row count for write should be 1 and not " + nbRows));
            }
            if (tx == null) {
                JdbcUtils.commitAndClose(con);
            }
            this.logger.debug((Object)"MuleEvent dispatched succesfuly");
        }
        catch (Exception e) {
            this.logger.debug((Object)("Error dispatching event: " + e.getMessage()), (Throwable)e);
            if (tx == null) {
                JdbcUtils.rollbackAndClose(con);
            }
            throw e;
        }
    }

    protected String getStatement(ImmutableEndpoint endpoint) {
        String writeStmt = endpoint.getEndpointURI().getAddress();
        String str = this.connector.getQuery(endpoint, writeStmt);
        if (str != null) {
            writeStmt = str;
        }
        if (StringUtils.isBlank((String)(writeStmt = StringUtils.trimToEmpty((String)writeStmt)))) {
            throw new IllegalArgumentException("Missing statement");
        }
        return writeStmt;
    }

    protected boolean isWriteStatement(String writeStmt) {
        return "insert".equalsIgnoreCase(writeStmt.substring(0, 6)) || "update".equalsIgnoreCase(writeStmt.substring(0, 6)) || "delete".equalsIgnoreCase(writeStmt.substring(0, 6)) || "merge".equalsIgnoreCase(writeStmt.substring(0, 5)) || "call".equalsIgnoreCase(writeStmt.substring(0, 4));
    }

    protected void doDispatch(MuleEvent event) throws Exception {
        String writeStmt;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Dispatch event: " + event));
        }
        if (!this.isWriteStatement(writeStmt = this.getStatement(event.getEndpoint()))) {
            throw new IllegalArgumentException("Write statement should be an insert / update / delete / merge sql statement, or a stored-procedure call");
        }
        this.executeWriteStatement(event, writeStmt);
    }

    protected MuleMessage doSend(MuleEvent event) throws Exception {
        String statement = this.getStatement(event.getEndpoint());
        if (this.isWriteStatement(statement)) {
            this.executeWriteStatement(event, statement);
            return event.getMessage();
        }
        return JdbcMessageDispatcher.executeRequest(event.getTimeout(), event, this.connector, this.endpoint);
    }

    protected static MuleMessage executeRequest(long timeout, MuleEvent event, JdbcConnector connector, ImmutableEndpoint endpoint) throws Exception {
        if (staticLogger.isDebugEnabled()) {
            staticLogger.debug((Object)("Trying to receive a message with a timeout of " + timeout));
        }
        String[] stmts = connector.getReadAndAckStatements(endpoint);
        String readStmt = stmts[0];
        String ackStmt = stmts[1];
        ArrayList readParams = new ArrayList();
        ArrayList ackParams = new ArrayList();
        readStmt = connector.parseStatement(readStmt, readParams);
        ackStmt = connector.parseStatement(ackStmt, ackParams);
        Connection con = null;
        long t0 = System.currentTimeMillis();
        try {
            Object result;
            Object[] params;
            block12: {
                con = connector.getConnection();
                if (timeout < 0L) {
                    timeout = Long.MAX_VALUE;
                }
                while (true) {
                    params = connector.getParams(endpoint, readParams, event != null ? event.getMessage() : null, endpoint.getEndpointURI().getAddress());
                    if (staticLogger.isDebugEnabled()) {
                        staticLogger.debug((Object)("SQL QUERY: " + readStmt + ", params = " + ArrayUtils.toString((Object)params)));
                    }
                    if ((result = connector.getQueryRunner().query(con, readStmt, params, connector.getResultSetHandler())) != null) {
                        if (staticLogger.isDebugEnabled()) {
                            staticLogger.debug((Object)("Received: " + result));
                        }
                        break block12;
                    }
                    long sleep = Math.min(connector.getPollingFrequency(), timeout - (System.currentTimeMillis() - t0));
                    if (sleep <= 0L) break;
                    if (staticLogger.isDebugEnabled()) {
                        staticLogger.debug((Object)("No results, sleeping for " + sleep));
                    }
                    Thread.sleep(sleep);
                }
                staticLogger.debug((Object)"Timeout");
                return null;
            }
            if (ackStmt != null) {
                int nbRows;
                params = connector.getParams(endpoint, ackParams, result, ackStmt);
                if (staticLogger.isDebugEnabled()) {
                    staticLogger.debug((Object)("SQL UPDATE: " + ackStmt + ", params = " + ArrayUtils.toString((Object)params)));
                }
                if ((nbRows = connector.getQueryRunner().update(con, ackStmt, params)) != 1) {
                    staticLogger.warn((Object)("Row count for ack should be 1 and not " + nbRows));
                }
            }
            MessageAdapter msgAdapter = connector.getMessageAdapter(result);
            DefaultMuleMessage message = new DefaultMuleMessage((Object)msgAdapter);
            JdbcUtils.commitAndClose(con);
            return message;
        }
        catch (Exception e) {
            JdbcUtils.rollbackAndClose(con);
            throw e;
        }
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }
}

