/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.service.Service;
import org.mule.api.transaction.Transaction;
import org.mule.api.transport.Connectable;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageAdapter;
import org.mule.transaction.TransactionCoordination;
import org.mule.transport.ConnectException;
import org.mule.transport.TransactedPollingMessageReceiver;
import org.mule.transport.jdbc.JdbcConnector;
import org.mule.transport.jdbc.JdbcUtils;
import org.mule.util.ArrayUtils;

public class JdbcMessageReceiver
extends TransactedPollingMessageReceiver {
    protected JdbcConnector connector;
    protected String readStmt;
    protected String ackStmt;
    protected List readParams;
    protected List ackParams;

    public JdbcMessageReceiver(Connector connector, Service service, InboundEndpoint endpoint, String readStmt, String ackStmt) throws CreateException {
        super(connector, service, endpoint);
        this.setFrequency(((JdbcConnector)connector).getPollingFrequency());
        this.setReceiveMessagesInTransaction(false);
        this.connector = (JdbcConnector)connector;
        this.readParams = new ArrayList();
        this.readStmt = this.connector.parseStatement(readStmt, this.readParams);
        this.ackParams = new ArrayList();
        this.ackStmt = this.connector.parseStatement(ackStmt, this.ackParams);
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
        Connection con = null;
        try {
            con = this.connector.getConnection();
        }
        catch (Exception e) {
            throw new ConnectException((Throwable)e, (Connectable)this);
        }
        finally {
            JdbcUtils.close(con);
        }
    }

    protected void doDisconnect() throws ConnectException {
    }

    public void processMessage(Object message) throws Exception {
        Connection con = null;
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        try {
            con = this.connector.getConnection();
            MessageAdapter msgAdapter = this.connector.getMessageAdapter(message);
            DefaultMuleMessage umoMessage = new DefaultMuleMessage((Object)msgAdapter);
            if (this.ackStmt != null) {
                int nbRows;
                Object[] ackParams = this.connector.getParams((ImmutableEndpoint)this.endpoint, this.ackParams, umoMessage, this.endpoint.getEndpointURI().getAddress());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("SQL UPDATE: " + this.ackStmt + ", params = " + ArrayUtils.toString((Object)ackParams)));
                }
                if ((nbRows = this.connector.getQueryRunner().update(con, this.ackStmt, ackParams)) != 1) {
                    this.logger.warn((Object)("Row count for ack should be 1 and not " + nbRows));
                }
            }
            this.routeMessage((MuleMessage)umoMessage, tx, tx != null || this.endpoint.isSynchronous());
        }
        catch (Exception ex) {
            if (tx != null) {
                tx.setRollbackOnly();
            }
            throw ex;
        }
        finally {
            if (this.endpoint.getMuleContext().getTransactionManager() != null || tx == null) {
                JdbcUtils.close(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMessages() throws Exception {
        List list;
        Connection con = null;
        try {
            try {
                con = this.connector.getConnection();
            }
            catch (SQLException e) {
                throw new ConnectException((Throwable)e, (Connectable)this);
            }
            Object[] readParams = this.connector.getParams((ImmutableEndpoint)this.endpoint, this.readParams, null, this.endpoint.getEndpointURI().getAddress());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("SQL QUERY: " + this.readStmt + ", params = " + ArrayUtils.toString((Object)readParams)));
            }
            Object results = this.connector.getQueryRunner().query(con, this.readStmt, readParams, this.connector.getResultSetHandler());
            list = (List)results;
        }
        catch (Throwable throwable) {
            JdbcUtils.close(con);
            throw throwable;
        }
        JdbcUtils.close(con);
        return list;
    }
}

