/*
 * $Id: SQLStrategy.java 12539 2008-08-20 19:40:19Z tcarlson $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.transport.jdbc.sqlstrategy;

/**
 * Interface for classes implementing strategies for handling SQL statements.  See 
 * <code>SQLStrategyFactory</code> for how a strategy is selected.   
 * 
 */

import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.transport.jdbc.JdbcConnector;

public interface SQLStrategy 
{
    
    public MuleMessage executeStatement(JdbcConnector connector,
    		                                   ImmutableEndpoint endpoint,
    		                                   MuleEvent event,
    		                                   long timeout) throws Exception;

}
