/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.xa;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transaction.TransactionCoordination;
import org.mule.transaction.XaTransaction;
import org.mule.transport.jdbc.xa.StatementInvocationHandler;

public class ConnectionWrapper
implements Connection,
XaTransaction.MuleXaObject {
    private final XAConnection xaConnection;
    private Connection connection;
    private volatile boolean enlisted = false;
    protected static final transient Log logger = LogFactory.getLog(ConnectionWrapper.class);
    private volatile boolean reuseObject = false;

    public ConnectionWrapper(XAConnection xaCon) throws SQLException {
        this.xaConnection = xaCon;
        this.connection = xaCon.getConnection();
    }

    public int getHoldability() throws SQLException {
        return this.connection.getHoldability();
    }

    public int getTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    public void clearWarnings() throws SQLException {
        this.connection.clearWarnings();
    }

    public void close() throws SQLException {
        this.connection.close();
    }

    public void commit() throws SQLException {
        this.connection.commit();
    }

    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    public boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    public boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    public void setHoldability(int holdability) throws SQLException {
        this.connection.setHoldability(holdability);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.connection.setTransactionIsolation(level);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.connection.setAutoCommit(autoCommit);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.connection.setReadOnly(readOnly);
    }

    public String getCatalog() throws SQLException {
        return this.connection.getCatalog();
    }

    public void setCatalog(String catalog) throws SQLException {
        this.connection.setCatalog(catalog);
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.getMetaData();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.connection.getWarnings();
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.connection.setSavepoint();
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.connection.releaseSavepoint(savepoint);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.connection.rollback();
    }

    public Statement createStatement() throws SQLException {
        Statement st = this.connection.createStatement();
        return (Statement)Proxy.newProxyInstance(Statement.class.getClassLoader(), new Class[]{Statement.class}, (InvocationHandler)new StatementInvocationHandler(this, st));
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement st = this.connection.createStatement(resultSetType, resultSetConcurrency);
        return (Statement)Proxy.newProxyInstance(Statement.class.getClassLoader(), new Class[]{Statement.class}, (InvocationHandler)new StatementInvocationHandler(this, st));
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Statement st = this.connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        return (Statement)Proxy.newProxyInstance(Statement.class.getClassLoader(), new Class[]{Statement.class}, (InvocationHandler)new StatementInvocationHandler(this, st));
    }

    public Map getTypeMap() throws SQLException {
        return this.connection.getTypeMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.connection.setTypeMap(map);
    }

    public String nativeSQL(String sql) throws SQLException {
        return this.connection.nativeSQL(sql);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        CallableStatement cs = this.connection.prepareCall(sql);
        return (CallableStatement)Proxy.newProxyInstance(CallableStatement.class.getClassLoader(), new Class[]{CallableStatement.class}, (InvocationHandler)new StatementInvocationHandler(this, cs));
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        CallableStatement cs = this.connection.prepareCall(sql, resultSetType, resultSetConcurrency);
        return (CallableStatement)Proxy.newProxyInstance(CallableStatement.class.getClassLoader(), new Class[]{CallableStatement.class}, (InvocationHandler)new StatementInvocationHandler(this, cs));
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CallableStatement cs = this.connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        return (CallableStatement)Proxy.newProxyInstance(CallableStatement.class.getClassLoader(), new Class[]{CallableStatement.class}, (InvocationHandler)new StatementInvocationHandler(this, cs));
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement ps = this.connection.prepareStatement(sql);
        return (PreparedStatement)Proxy.newProxyInstance(PreparedStatement.class.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)new StatementInvocationHandler(this, ps));
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatement ps = this.connection.prepareStatement(sql, autoGeneratedKeys);
        return (PreparedStatement)Proxy.newProxyInstance(PreparedStatement.class.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)new StatementInvocationHandler(this, ps));
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement ps = this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        return (PreparedStatement)Proxy.newProxyInstance(PreparedStatement.class.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)new StatementInvocationHandler(this, ps));
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement ps = this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        return (PreparedStatement)Proxy.newProxyInstance(PreparedStatement.class.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)new StatementInvocationHandler(this, ps));
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement ps = this.connection.prepareStatement(sql, columnIndexes);
        return (PreparedStatement)Proxy.newProxyInstance(PreparedStatement.class.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)new StatementInvocationHandler(this, ps));
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        return this.connection.setSavepoint(name);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PreparedStatement ps = this.connection.prepareStatement(sql, columnNames);
        return (PreparedStatement)Proxy.newProxyInstance(PreparedStatement.class.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)new StatementInvocationHandler(this, ps));
    }

    public boolean enlist() throws TransactionException {
        Transaction transaction;
        try {
            this.connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new TransactionException((Throwable)e);
        }
        if (this.isEnlisted()) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Enlistment request: " + this));
        }
        if ((transaction = TransactionCoordination.getInstance().getTransaction()) == null) {
            throw new IllegalTransactionStateException(CoreMessages.noMuleTransactionAvailable());
        }
        if (!(transaction instanceof XaTransaction)) {
            throw new IllegalTransactionStateException(CoreMessages.notMuleXaTransaction((Object)transaction));
        }
        if (!this.isEnlisted()) {
            XAResource xaResource;
            try {
                xaResource = this.xaConnection.getXAResource();
            }
            catch (SQLException e) {
                throw new TransactionException((Throwable)e);
            }
            this.enlisted = ((XaTransaction)transaction).enlistResource(xaResource);
        }
        return this.enlisted;
    }

    public boolean delist() throws Exception {
        Transaction transaction;
        if (!this.isEnlisted()) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Delistment request: " + this));
        }
        if ((transaction = TransactionCoordination.getInstance().getTransaction()) == null) {
            throw new IllegalTransactionStateException(CoreMessages.noMuleTransactionAvailable());
        }
        if (!(transaction instanceof XaTransaction)) {
            throw new IllegalTransactionStateException(CoreMessages.notMuleXaTransaction((Object)transaction));
        }
        if (this.isEnlisted()) {
            this.enlisted = !((XaTransaction)transaction).delistResource(this.xaConnection.getXAResource(), 0x4000000);
        }
        return !this.isEnlisted();
    }

    public boolean isEnlisted() {
        return this.enlisted;
    }

    public void setEnlisted(boolean enlisted) {
        this.enlisted = enlisted;
    }

    public boolean isReuseObject() {
        return this.reuseObject;
    }

    public void setReuseObject(boolean reuseObject) {
        this.reuseObject = reuseObject;
    }

    public Object getTargetObject() {
        return this.xaConnection;
    }
}

