/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.sqlstrategy;

import org.mule.transport.jdbc.sqlstrategy.CallableSQLStrategy;
import org.mule.transport.jdbc.sqlstrategy.SQLStrategy;
import org.mule.transport.jdbc.sqlstrategy.SelectSQLStrategy;
import org.mule.transport.jdbc.sqlstrategy.SimpleUpdateSQLStrategy;

public class SQLStrategyFactory {
    protected SimpleUpdateSQLStrategy simpleUpdateSQLStrategy = new SimpleUpdateSQLStrategy();
    protected SelectSQLStrategy selectSQLStrategy = new SelectSQLStrategy();
    protected CallableSQLStrategy callableSQLStrategy = new CallableSQLStrategy();

    public SQLStrategy create(String sql, Object payload) throws Exception {
        String sqlLowerCase = sql.toLowerCase();
        if (sqlLowerCase.startsWith("insert") || sqlLowerCase.startsWith("update") || sqlLowerCase.startsWith("delete") || sqlLowerCase.startsWith("merge")) {
            return this.simpleUpdateSQLStrategy;
        }
        if (sqlLowerCase.startsWith("select")) {
            return this.selectSQLStrategy;
        }
        if (sqlLowerCase.startsWith("call")) {
            return this.callableSQLStrategy;
        }
        throw new IllegalArgumentException("No SQL Strategy found for SQL statement: " + sql);
    }
}

