/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.mule.api.MuleException;
import org.mule.api.config.ExceptionReader;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.service.Service;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionException;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageReceiver;
import org.mule.config.ExceptionHelper;
import org.mule.config.i18n.MessageFactory;
import org.mule.transaction.TransactionCoordination;
import org.mule.transport.AbstractConnector;
import org.mule.transport.jdbc.JdbcUtils;
import org.mule.transport.jdbc.SQLExceptionReader;
import org.mule.transport.jdbc.sqlstrategy.SQLStrategyFactory;
import org.mule.transport.jdbc.xa.DataSourceWrapper;
import org.mule.util.StringUtils;
import org.mule.util.TemplateParser;
import org.mule.util.expression.ExpressionEvaluatorManager;

public class JdbcConnector
extends AbstractConnector {
    public static final String JDBC = "jdbc";
    public static final String PROPERTY_POLLING_FREQUENCY = "pollingFrequency";
    public static final long DEFAULT_POLLING_FREQUENCY = 1000L;
    private static final Pattern STATEMENT_ARGS = TemplateParser.WIGGLY_MULE_TEMPLATE_PATTERN;
    protected SQLStrategyFactory sqlStrategyFactory = new SQLStrategyFactory();
    protected long pollingFrequency = 0L;
    protected Map queries;
    protected DataSource dataSource;
    protected ResultSetHandler resultSetHandler;
    protected QueryRunner queryRunner;
    protected boolean transactionPerMessage = true;

    protected void doInitialise() throws InitialisationException {
        this.createMultipleTransactedReceivers = false;
        if (this.dataSource == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage((String)"Missing data source"), (Initialisable)this);
        }
        if (this.resultSetHandler == null) {
            this.resultSetHandler = new MapListHandler();
        }
        if (this.queryRunner == null) {
            this.queryRunner = new QueryRunner();
        }
    }

    public MessageReceiver createReceiver(Service service, InboundEndpoint endpoint) throws Exception {
        String tempPolling;
        Map props = endpoint.getProperties();
        if (props != null && (tempPolling = (String)props.get(PROPERTY_POLLING_FREQUENCY)) != null) {
            this.pollingFrequency = Long.parseLong(tempPolling);
        }
        if (this.pollingFrequency <= 0L) {
            this.pollingFrequency = 1000L;
        }
        Object[] params = this.getReadAndAckStatements((ImmutableEndpoint)endpoint);
        return this.getServiceDescriptor().createMessageReceiver((Connector)this, service, endpoint, params);
    }

    public String[] getReadAndAckStatements(ImmutableEndpoint endpoint) {
        String ackStmt;
        String str = (String)endpoint.getProperty((Object)"sql");
        String readStmt = str != null ? str : endpoint.getEndpointURI().getAddress();
        str = (String)endpoint.getProperty((Object)"ack");
        if (str != null) {
            ackStmt = str;
            if ((str = this.getQuery(endpoint, ackStmt)) != null) {
                ackStmt = str;
            }
            ackStmt = ackStmt.trim();
        } else {
            ackStmt = readStmt + ".ack";
            str = this.getQuery(endpoint, ackStmt);
            ackStmt = str != null ? str.trim() : null;
        }
        str = this.getQuery(endpoint, readStmt);
        if (str != null) {
            readStmt = str;
        }
        if (readStmt == null) {
            throw new IllegalArgumentException("Read statement should not be null");
        }
        if (!"select".equalsIgnoreCase((readStmt = readStmt.trim()).substring(0, 6)) && !"call".equalsIgnoreCase(readStmt.substring(0, 4))) {
            throw new IllegalArgumentException("Read statement should be a select sql statement or a stored procedure");
        }
        if (!(ackStmt == null || "insert".equalsIgnoreCase(ackStmt.substring(0, 6)) || "update".equalsIgnoreCase(ackStmt.substring(0, 6)) || "delete".equalsIgnoreCase(ackStmt.substring(0, 6)))) {
            throw new IllegalArgumentException("Ack statement should be an insert / update / delete sql statement");
        }
        return new String[]{readStmt, ackStmt};
    }

    public String getQuery(ImmutableEndpoint endpoint, String stmt) {
        Object queries;
        Object query = null;
        if (endpoint != null && endpoint.getProperties() != null && (queries = endpoint.getProperties().get("queries")) instanceof Map) {
            query = ((Map)queries).get(stmt);
        }
        if (query == null && this.queries != null) {
            query = this.queries.get(stmt);
        }
        return query == null ? null : query.toString();
    }

    public Connection getConnection() throws Exception {
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        if (tx != null && tx.hasResource((Object)this.dataSource)) {
            this.logger.debug((Object)("Retrieving connection from current transaction: " + tx));
            return (Connection)tx.getResource((Object)this.dataSource);
        }
        this.logger.debug((Object)"Retrieving new connection from data source");
        Connection con = this.dataSource.getConnection();
        if (tx != null) {
            this.logger.debug((Object)("Binding connection " + con + " to current transaction: " + tx));
            try {
                tx.bindResource((Object)this.dataSource, (Object)con);
            }
            catch (TransactionException e) {
                JdbcUtils.close(con);
                throw new RuntimeException("Could not bind connection to current transaction: " + tx, e);
            }
        }
        return con;
    }

    public boolean isTransactionPerMessage() {
        return this.transactionPerMessage;
    }

    public void setTransactionPerMessage(boolean transactionPerMessage) {
        this.transactionPerMessage = transactionPerMessage;
        if (!transactionPerMessage) {
            this.logger.warn((Object)"transactionPerMessage property is set to false so setting createMultipleTransactedReceivers to false also to prevent creation of multiple JdbcMessageReceivers");
            this.setCreateMultipleTransactedReceivers(transactionPerMessage);
        }
    }

    public String parseStatement(String stmt, List params) {
        if (stmt == null) {
            return stmt;
        }
        Matcher m = STATEMENT_ARGS.matcher(stmt);
        StringBuffer sb = new StringBuffer(200);
        while (m.find()) {
            String key = m.group();
            m.appendReplacement(sb, "?");
            if (key.equals("#[payload]")) {
                this.logger.error((Object)"invalid expression template #[payload]. It should be replaced with #[payload:] to conform with the correct expression syntax. Mule has replaced this for you, but may not in future versions.");
                key = "#[payload:]";
            }
            params.add(key);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public Object[] getParams(ImmutableEndpoint endpoint, List paramNames, Object message, String query) throws Exception {
        Object[] params = new Object[paramNames.size()];
        for (int i = 0; i < paramNames.size(); ++i) {
            String param = (String)paramNames.get(i);
            Object value = null;
            boolean foundValue = false;
            boolean validExpression = ExpressionEvaluatorManager.isValidExpression((String)param);
            if (message != null && validExpression) {
                value = ExpressionEvaluatorManager.evaluate((String)param, (Object)message);
                boolean bl = foundValue = value != null;
            }
            if (!foundValue) {
                String name = param.substring(2, param.length() - 1);
                if (!validExpression) {
                    this.logger.warn((Object)MessageFormat.format("Config is using the legacy param format {0} (no evaluator defined). This expression can be replaced with {1}header:{2}{3}", param, "#[", name, "]"));
                }
                value = endpoint.getProperty((Object)name);
            }
            params[i] = value;
        }
        return params;
    }

    protected String getNameFromParam(String param) {
        return param.substring(2, param.length() - 1);
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }

    public String getProtocol() {
        return JDBC;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource instanceof XADataSource ? new DataSourceWrapper((XADataSource)((Object)dataSource)) : dataSource;
    }

    public ResultSetHandler getResultSetHandler() {
        return this.resultSetHandler;
    }

    public void setResultSetHandler(ResultSetHandler resultSetHandler) {
        this.resultSetHandler = resultSetHandler;
    }

    public QueryRunner getQueryRunner() {
        return this.queryRunner;
    }

    public void setQueryRunner(QueryRunner queryRunner) {
        this.queryRunner = queryRunner;
    }

    public long getPollingFrequency() {
        return this.pollingFrequency;
    }

    public void setPollingFrequency(long pollingFrequency) {
        this.pollingFrequency = pollingFrequency;
    }

    public Map getQueries() {
        return this.queries;
    }

    public void setQueries(Map queries) {
        this.queries = queries;
    }

    public SQLStrategyFactory getSqlStrategyFactory() {
        return this.sqlStrategyFactory;
    }

    public String getStatement(ImmutableEndpoint endpoint) {
        String writeStmt = endpoint.getEndpointURI().getAddress();
        String str = this.getQuery(endpoint, writeStmt);
        if (str != null) {
            writeStmt = str;
        }
        if (StringUtils.isBlank((String)(writeStmt = StringUtils.trimToEmpty((String)writeStmt)))) {
            throw new IllegalArgumentException("Missing statement");
        }
        return writeStmt;
    }

    static {
        ExceptionHelper.registerExceptionReader((ExceptionReader)new SQLExceptionReader());
    }
}

