/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.sqlstrategy;

import java.sql.Connection;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.transaction.Transaction;
import org.mule.transaction.TransactionCoordination;
import org.mule.transport.jdbc.JdbcConnector;
import org.mule.transport.jdbc.JdbcUtils;
import org.mule.transport.jdbc.sqlstrategy.SQLStrategy;
import org.mule.transport.jdbc.sqlstrategy.SelectSQLStrategy;
import org.mule.util.ArrayUtils;

public class SimpleUpdateSQLStrategy
implements SQLStrategy {
    protected static Logger logger = Logger.getLogger(SelectSQLStrategy.class);

    public MuleMessage executeStatement(JdbcConnector connector, ImmutableEndpoint endpoint, MuleEvent event, long timeout) throws Exception {
        String statement = connector.getStatement(endpoint);
        ArrayList paramNames = new ArrayList();
        String sql = connector.parseStatement(statement, paramNames);
        sql = this.escapeStatement(sql);
        Object[] paramValues = connector.getParams(endpoint, paramNames, new DefaultMuleMessage(event.transformMessage()), endpoint.getEndpointURI().getAddress());
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        Connection con = null;
        try {
            int nbRows;
            con = connector.getConnection();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("SQL UPDATE: " + sql + ", params = " + ArrayUtils.toString((Object)paramValues)));
            }
            if ((nbRows = connector.getQueryRunner().update(con, sql, paramValues)) != 1) {
                logger.warn((Object)("Row count for write should be 1 and not " + nbRows));
            }
            if (tx == null) {
                JdbcUtils.commitAndClose(con);
            }
            logger.debug((Object)"MuleEvent dispatched succesfuly");
        }
        catch (Exception e) {
            logger.debug((Object)("Error dispatching event: " + e.getMessage()), (Throwable)e);
            if (tx == null) {
                JdbcUtils.rollbackAndClose(con);
            }
            throw e;
        }
        return event.getMessage();
    }

    protected String escapeStatement(String statement) {
        return statement;
    }
}

