/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.jdbc.JdbcConnector;
import org.mule.transport.jdbc.sqlstrategy.SqlStatementStrategy;

public class JdbcMessageDispatcher
extends AbstractMessageDispatcher {
    protected static Log staticLogger = LogFactory.getLog(AbstractMessageDispatcher.class);
    protected JdbcConnector connector;

    public JdbcMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (JdbcConnector)endpoint.getConnector();
    }

    protected void doDispose() {
    }

    protected void doDispatch(MuleEvent event) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Dispatch event: " + event));
        }
        this.doSend(event);
    }

    protected MuleMessage doSend(MuleEvent event) throws Exception {
        ImmutableEndpoint endpoint = event.getEndpoint();
        JdbcConnector connector = (JdbcConnector)endpoint.getConnector();
        String statement = connector.getStatement(endpoint);
        SqlStatementStrategy strategy = connector.getSqlStatementStrategyFactory().create(statement, event.getMessage().getPayload());
        return strategy.executeStatement(connector, endpoint, event, event.getTimeout());
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }
}

