/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.config;

import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.tck.FunctionalTestCase;
import org.mule.transaction.XaTransactionFactory;
import org.mule.transport.jdbc.JdbcConnector;
import org.mule.transport.jdbc.JdbcTransactionFactory;
import org.mule.transport.jdbc.sqlstrategy.DefaultSqlStatementStrategyFactory;
import org.mule.transport.jdbc.test.TestDataSource;

public class JdbcNamespaceHandlerTestCase
extends FunctionalTestCase {
    protected String getConfigResources() {
        return "jdbc-namespace-config.xml";
    }

    public void testWithDataSource() throws Exception {
        JdbcConnector c = (JdbcConnector)muleContext.getRegistry().lookupConnector("jdbcConnector1");
        JdbcNamespaceHandlerTestCase.assertNotNull((Object)c);
        JdbcNamespaceHandlerTestCase.assertTrue((boolean)(c.getDataSource() instanceof TestDataSource));
        JdbcNamespaceHandlerTestCase.assertNull((Object)c.getQueries());
    }

    public void testWithDataSourceViaJndi() throws Exception {
        JdbcConnector c = (JdbcConnector)muleContext.getRegistry().lookupConnector("jdbcConnector2");
        JdbcNamespaceHandlerTestCase.assertNotNull((Object)c);
        JdbcNamespaceHandlerTestCase.assertTrue((boolean)(c.getDataSource() instanceof TestDataSource));
        JdbcNamespaceHandlerTestCase.assertNull((Object)c.getQueries());
        JdbcNamespaceHandlerTestCase.assertTrue((boolean)c.isConnected());
        JdbcNamespaceHandlerTestCase.assertTrue((boolean)c.isStarted());
    }

    public void testFullyConfigured() throws Exception {
        JdbcConnector c = (JdbcConnector)muleContext.getRegistry().lookupConnector("jdbcConnector3");
        JdbcNamespaceHandlerTestCase.assertNotNull((Object)c);
        JdbcNamespaceHandlerTestCase.assertTrue((boolean)(c.getDataSource() instanceof TestDataSource));
        JdbcNamespaceHandlerTestCase.assertNotNull((Object)c.getQueries());
        JdbcNamespaceHandlerTestCase.assertEquals((int)3, (int)c.getQueries().size());
        JdbcNamespaceHandlerTestCase.assertTrue((boolean)c.isConnected());
        JdbcNamespaceHandlerTestCase.assertTrue((boolean)c.isStarted());
    }

    public void testEndpointQueryOverride() throws Exception {
        JdbcConnector c = (JdbcConnector)muleContext.getRegistry().lookupConnector("jdbcConnector3");
        InboundEndpoint testJdbcEndpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("testJdbcEndpoint");
        JdbcNamespaceHandlerTestCase.assertNotNull((Object)c.getQuery((ImmutableEndpoint)testJdbcEndpoint, "getTest"));
        JdbcNamespaceHandlerTestCase.assertNotNull((Object)c.getQuery((ImmutableEndpoint)testJdbcEndpoint, "getTest2"));
        JdbcNamespaceHandlerTestCase.assertEquals((String)"OVERRIDDEN VALUE", (String)c.getQuery((ImmutableEndpoint)testJdbcEndpoint, "getTest2"));
        JdbcNamespaceHandlerTestCase.assertNotNull((Object)c.getQuery((ImmutableEndpoint)testJdbcEndpoint, "getTest3"));
        JdbcNamespaceHandlerTestCase.assertNull((Object)c.getQuery((ImmutableEndpoint)testJdbcEndpoint, "getTest4"));
    }

    public void testEndpointWithTransaction() throws Exception {
        InboundEndpoint endpoint = muleContext.getRegistry().lookupEndpointBuilder("endpointWithTransaction").buildInboundEndpoint();
        JdbcNamespaceHandlerTestCase.assertNotNull((Object)endpoint);
        JdbcNamespaceHandlerTestCase.assertEquals(JdbcTransactionFactory.class, endpoint.getTransactionConfig().getFactory().getClass());
        JdbcNamespaceHandlerTestCase.assertEquals((byte)0, (byte)endpoint.getTransactionConfig().getAction());
    }

    public void testEndpointWithXaTransaction() throws Exception {
        InboundEndpoint endpoint = muleContext.getRegistry().lookupEndpointBuilder("endpointWithXaTransaction").buildInboundEndpoint();
        JdbcNamespaceHandlerTestCase.assertNotNull((Object)endpoint);
        JdbcNamespaceHandlerTestCase.assertEquals(XaTransactionFactory.class, endpoint.getTransactionConfig().getFactory().getClass());
        JdbcNamespaceHandlerTestCase.assertEquals((byte)1, (byte)endpoint.getTransactionConfig().getAction());
    }

    public void testSqlStatementStrategyFactoryOverride() throws Exception {
        JdbcConnector c = (JdbcConnector)muleContext.getRegistry().lookupConnector("jdbcConnector4");
        JdbcNamespaceHandlerTestCase.assertNotNull((Object)c.getSqlStatementStrategyFactory());
        JdbcNamespaceHandlerTestCase.assertTrue((boolean)(c.getSqlStatementStrategyFactory() instanceof TestSqlStatementStrategyFactory));
        c = (JdbcConnector)muleContext.getRegistry().lookupConnector("jdbcConnector5");
        JdbcNamespaceHandlerTestCase.assertNotNull((Object)c.getSqlStatementStrategyFactory());
        JdbcNamespaceHandlerTestCase.assertTrue((boolean)(c.getSqlStatementStrategyFactory() instanceof TestSqlStatementStrategyFactory));
    }

    public static class TestSqlStatementStrategyFactory
    extends DefaultSqlStatementStrategyFactory {
    }
}

