/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.functional;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.transport.jdbc.functional.AbstractJdbcFunctionalTestCase;

public class JdbcSelectOnOutboundFunctionalTestCase
extends AbstractJdbcFunctionalTestCase {
    protected String getConfigResources() {
        return super.getConfigResources() + ",jdbc-select-outbound.xml";
    }

    public void testSelectOnOutbound() throws Exception {
        this.doSelectOnOutbound("vm://jdbc.test");
    }

    public void testSelectOnOutboundByExpression() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MyMessage payload = new MyMessage(2);
        MuleMessage reply = client.send("vm://terra", (MuleMessage)new DefaultMuleMessage((Object)payload, muleContext));
        JdbcSelectOnOutboundFunctionalTestCase.assertNotNull((Object)reply.getPayload());
        JdbcSelectOnOutboundFunctionalTestCase.assertTrue((boolean)(reply.getPayload() instanceof List));
        List resultList = (List)reply.getPayload();
        JdbcSelectOnOutboundFunctionalTestCase.assertTrue((resultList.size() == 1 ? 1 : 0) != 0);
        JdbcSelectOnOutboundFunctionalTestCase.assertTrue((boolean)(resultList.get(0) instanceof Map));
        Map resultMap = (Map)resultList.get(0);
        JdbcSelectOnOutboundFunctionalTestCase.assertEquals((Object)new Integer(2), resultMap.get("TYPE"));
        JdbcSelectOnOutboundFunctionalTestCase.assertEquals((Object)TEST_VALUES[1], resultMap.get("DATA"));
    }

    public void testChain2SelectAlwaysBegin() throws Exception {
        this.doSelectOnOutbound("vm://chain.always.begin");
    }

    public void testChain2SelectBeginOrJoin() throws Exception {
        this.doSelectOnOutbound("vm://chain.begin.or.join");
    }

    private void doSelectOnOutbound(String endpoint) throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage reply = client.send(endpoint, new Object(), null);
        JdbcSelectOnOutboundFunctionalTestCase.assertNotNull((Object)reply.getPayload());
        JdbcSelectOnOutboundFunctionalTestCase.assertTrue((boolean)(reply.getPayload() instanceof List));
        List resultList = (List)reply.getPayload();
        JdbcSelectOnOutboundFunctionalTestCase.assertTrue((resultList.size() == 1 ? 1 : 0) != 0);
        JdbcSelectOnOutboundFunctionalTestCase.assertTrue((boolean)(resultList.get(0) instanceof Map));
        Map resultMap = (Map)resultList.get(0);
        JdbcSelectOnOutboundFunctionalTestCase.assertEquals((Object)new Integer(1), resultMap.get("TYPE"));
        JdbcSelectOnOutboundFunctionalTestCase.assertEquals((Object)TEST_VALUES[0], resultMap.get("DATA"));
    }

    public static class MyMessage
    implements Serializable {
        private int type;

        public MyMessage(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }
    }
}

