/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.xa;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transaction.TransactionCoordination;
import org.mule.transaction.XaTransaction;
import org.mule.transport.jdbc.xa.StatementInvocationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionWrapper
implements Connection,
XaTransaction.MuleXaObject {
    private final XAConnection xaConnection;
    private Connection connection;
    private volatile boolean enlisted = false;
    protected static final transient Log logger = LogFactory.getLog(ConnectionWrapper.class);
    private volatile boolean reuseObject = false;

    public ConnectionWrapper(XAConnection xaCon) throws SQLException {
        this.xaConnection = xaCon;
        this.connection = xaCon.getConnection();
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.connection.getHoldability();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.connection.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this.connection.close();
    }

    @Override
    public void commit() throws SQLException {
        this.connection.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.connection.setHoldability(holdability);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.connection.setTransactionIsolation(level);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.connection.setAutoCommit(autoCommit);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.connection.setReadOnly(readOnly);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.connection.getCatalog();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.connection.setCatalog(catalog);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.getMetaData();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.connection.getWarnings();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.connection.setSavepoint();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.connection.releaseSavepoint(savepoint);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.connection.rollback();
    }

    @Override
    public Statement createStatement() throws SQLException {
        Statement st = this.connection.createStatement();
        return (Statement)Proxy.newProxyInstance(Statement.class.getClassLoader(), new Class[]{Statement.class}, (InvocationHandler)new StatementInvocationHandler(this, st));
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement st = this.connection.createStatement(resultSetType, resultSetConcurrency);
        return (Statement)Proxy.newProxyInstance(Statement.class.getClassLoader(), new Class[]{Statement.class}, (InvocationHandler)new StatementInvocationHandler(this, st));
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Statement st = this.connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        return (Statement)Proxy.newProxyInstance(Statement.class.getClassLoader(), new Class[]{Statement.class}, (InvocationHandler)new StatementInvocationHandler(this, st));
    }

    public Map getTypeMap() throws SQLException {
        return this.connection.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.connection.setTypeMap(map);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.connection.nativeSQL(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        CallableStatement cs = this.connection.prepareCall(sql);
        return (CallableStatement)Proxy.newProxyInstance(CallableStatement.class.getClassLoader(), new Class[]{CallableStatement.class}, (InvocationHandler)new StatementInvocationHandler(this, cs));
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        CallableStatement cs = this.connection.prepareCall(sql, resultSetType, resultSetConcurrency);
        return (CallableStatement)Proxy.newProxyInstance(CallableStatement.class.getClassLoader(), new Class[]{CallableStatement.class}, (InvocationHandler)new StatementInvocationHandler(this, cs));
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CallableStatement cs = this.connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        return (CallableStatement)Proxy.newProxyInstance(CallableStatement.class.getClassLoader(), new Class[]{CallableStatement.class}, (InvocationHandler)new StatementInvocationHandler(this, cs));
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement ps = this.connection.prepareStatement(sql);
        return (PreparedStatement)Proxy.newProxyInstance(PreparedStatement.class.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)new StatementInvocationHandler(this, ps));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatement ps = this.connection.prepareStatement(sql, autoGeneratedKeys);
        return (PreparedStatement)Proxy.newProxyInstance(PreparedStatement.class.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)new StatementInvocationHandler(this, ps));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement ps = this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        return (PreparedStatement)Proxy.newProxyInstance(PreparedStatement.class.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)new StatementInvocationHandler(this, ps));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement ps = this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        return (PreparedStatement)Proxy.newProxyInstance(PreparedStatement.class.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)new StatementInvocationHandler(this, ps));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement ps = this.connection.prepareStatement(sql, columnIndexes);
        return (PreparedStatement)Proxy.newProxyInstance(PreparedStatement.class.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)new StatementInvocationHandler(this, ps));
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.connection.setSavepoint(name);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PreparedStatement ps = this.connection.prepareStatement(sql, columnNames);
        return (PreparedStatement)Proxy.newProxyInstance(PreparedStatement.class.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)new StatementInvocationHandler(this, ps));
    }

    public boolean enlist() throws TransactionException {
        Transaction transaction;
        try {
            this.connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new TransactionException((Throwable)e);
        }
        if (this.isEnlisted()) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Enlistment request: " + this));
        }
        if ((transaction = TransactionCoordination.getInstance().getTransaction()) == null) {
            throw new IllegalTransactionStateException(CoreMessages.noMuleTransactionAvailable());
        }
        if (!(transaction instanceof XaTransaction)) {
            throw new IllegalTransactionStateException(CoreMessages.notMuleXaTransaction((Object)transaction));
        }
        if (!this.isEnlisted()) {
            XAResource xaResource;
            try {
                xaResource = this.xaConnection.getXAResource();
            }
            catch (SQLException e) {
                throw new TransactionException((Throwable)e);
            }
            this.enlisted = ((XaTransaction)transaction).enlistResource(xaResource);
        }
        return this.enlisted;
    }

    public boolean delist() throws Exception {
        Transaction transaction;
        if (!this.isEnlisted()) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Delistment request: " + this));
        }
        if ((transaction = TransactionCoordination.getInstance().getTransaction()) == null) {
            throw new IllegalTransactionStateException(CoreMessages.noMuleTransactionAvailable());
        }
        if (!(transaction instanceof XaTransaction)) {
            throw new IllegalTransactionStateException(CoreMessages.notMuleXaTransaction((Object)transaction));
        }
        if (this.isEnlisted()) {
            this.enlisted = !((XaTransaction)transaction).delistResource(this.xaConnection.getXAResource(), 0x4000000);
        }
        return !this.isEnlisted();
    }

    public boolean isEnlisted() {
        return this.enlisted;
    }

    public void setEnlisted(boolean enlisted) {
        this.enlisted = enlisted;
    }

    public boolean isReuseObject() {
        return this.reuseObject;
    }

    public void setReuseObject(boolean reuseObject) {
        this.reuseObject = reuseObject;
    }

    public Object getTargetObject() {
        return this.xaConnection;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.connection.createArrayOf(typeName, elements);
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.connection.createBlob();
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.connection.createClob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.connection.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.connection.createSQLXML();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.connection.createStruct(typeName, attributes);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.connection.getClientInfo();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.connection.getClientInfo(name);
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.connection.isValid(timeout);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.connection.setClientInfo(properties);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.connection.setClientInfo(name, value);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.connection.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.connection.unwrap(iface);
    }
}

