/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.functional;

import java.sql.Connection;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.mule.api.MuleMessage;
import org.mule.tck.FunctionalTestCase;
import org.mule.tck.util.MuleDerbyTestUtils;
import org.mule.transport.jdbc.JdbcConnector;
import org.mule.transport.jdbc.JdbcUtils;

public abstract class AbstractJdbcFunctionalTestCase
extends FunctionalTestCase {
    protected static final String[] TEST_VALUES = new String[]{"Test", "The Moon", "Terra"};
    protected JdbcConnector jdbcConnector;
    private boolean populateTestData = true;

    protected String getConfigResources() {
        return "jdbc-connector.xml";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.jdbcConnector = (JdbcConnector)muleContext.getRegistry().lookupConnector("jdbcConnector");
        try {
            this.deleteTable();
        }
        catch (Exception e) {
            this.createTable();
        }
        if (this.populateTestData) {
            this.populateTable();
        }
    }

    protected void doTearDown() throws Exception {
        this.deleteTable();
        super.doTearDown();
    }

    protected void createTable() throws Exception {
        QueryRunner qr = this.jdbcConnector.getQueryRunner();
        qr.update(this.jdbcConnector.getConnection(), "CREATE TABLE TEST(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0)  NOT NULL PRIMARY KEY,TYPE INTEGER,DATA VARCHAR(255),ACK TIMESTAMP,RESULT VARCHAR(255))");
        this.logger.debug((Object)"Table created");
    }

    protected void deleteTable() throws Exception {
        QueryRunner qr = this.jdbcConnector.getQueryRunner();
        int updated = qr.update(this.jdbcConnector.getConnection(), "DELETE FROM TEST");
        this.logger.debug((Object)(updated + " rows deleted"));
    }

    protected void populateTable() throws Exception {
        QueryRunner qr = this.jdbcConnector.getQueryRunner();
        int updated = qr.update(this.jdbcConnector.getConnection(), "INSERT INTO TEST(TYPE, DATA) VALUES (1, '" + TEST_VALUES[0] + "')");
        this.logger.debug((Object)(updated + " rows updated"));
        updated = qr.update(this.jdbcConnector.getConnection(), "INSERT INTO TEST(TYPE, DATA) VALUES (2, '" + TEST_VALUES[1] + "')");
        this.logger.debug((Object)(updated + " rows updated"));
        updated = qr.update(this.jdbcConnector.getConnection(), "INSERT INTO TEST(TYPE, DATA) VALUES (3, '" + TEST_VALUES[2] + "')");
        this.logger.debug((Object)(updated + " rows updated"));
    }

    protected void suitePreSetUp() throws Exception {
        MuleDerbyTestUtils.defaultDerbyCleanAndInit((String)"derby.properties", (String)"database.name");
        super.suitePreSetUp();
    }

    protected static void assertResultSetEmpty(MuleMessage message) {
        AbstractJdbcFunctionalTestCase.assertNotNull((Object)message);
        Object payload = message.getPayload();
        AbstractJdbcFunctionalTestCase.assertTrue((boolean)(payload instanceof List));
        List list = (List)payload;
        AbstractJdbcFunctionalTestCase.assertTrue((boolean)list.isEmpty());
    }

    protected static void assertResultSetNotEmpty(MuleMessage message) {
        AbstractJdbcFunctionalTestCase.assertNotNull((Object)message);
        Object payload = message.getPayload();
        AbstractJdbcFunctionalTestCase.assertTrue((boolean)(payload instanceof List));
        List list = (List)payload;
        AbstractJdbcFunctionalTestCase.assertFalse((boolean)list.isEmpty());
    }

    public boolean isPopulateTestData() {
        return this.populateTestData;
    }

    public void setPopulateTestData(boolean populateTestData) {
        this.populateTestData = populateTestData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List execSqlQuery(String sql) throws Exception {
        Connection con = null;
        try {
            con = this.jdbcConnector.getConnection();
            List list = (List)new QueryRunner().query(con, sql, (ResultSetHandler)new ArrayListHandler());
            return list;
        }
        finally {
            JdbcUtils.close((Connection)con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int execSqlUpdate(String sql) throws Exception {
        Connection con = null;
        try {
            con = this.jdbcConnector.getConnection();
            int n = new QueryRunner().update(con, sql);
            return n;
        }
        finally {
            JdbcUtils.close((Connection)con);
        }
    }
}

