/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.functional;

import java.sql.Connection;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.mule.transport.jdbc.functional.AbstractJdbcFunctionalTestCase;

public class JdbcBridgeFunctionalTestCase
extends AbstractJdbcFunctionalTestCase {
    private static final int TEST_ROWS = 10;

    public JdbcBridgeFunctionalTestCase() {
        this.setPopulateTestData(false);
    }

    protected String getConfigResources() {
        return "jdbc-bridge.xml";
    }

    protected void createTable() throws Exception {
        this.execSqlUpdate("CREATE TABLE TEST(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,TYPE INTEGER,DATA VARCHAR(255))");
        this.execSqlUpdate("CREATE TABLE TEST_OUT(ID INTEGER NOT NULL PRIMARY KEY,TYPE INTEGER,DATA VARCHAR(255))");
    }

    protected void deleteTable() throws Exception {
        this.execSqlUpdate("DELETE FROM TEST");
        this.execSqlUpdate("DELETE FROM TEST_OUT");
    }

    public void testBridgeSuccess() throws Exception {
        List results = this.execSqlQuery("SELECT * FROM TEST");
        JdbcBridgeFunctionalTestCase.assertEquals((int)0, (int)results.size());
        this.doTestBridge();
    }

    protected void doTestBridge() throws Exception {
        QueryRunner queryRunner = this.jdbcConnector.getQueryRunner();
        Connection connection = this.jdbcConnector.getConnection();
        for (int i = 0; i < 10; ++i) {
            queryRunner.update(connection, "INSERT INTO TEST(TYPE, DATA) VALUES (1, 'Test " + i + "')");
        }
        List results = (List)queryRunner.query(connection, "SELECT * FROM TEST WHERE TYPE = 1", (ResultSetHandler)new ArrayListHandler());
        JdbcBridgeFunctionalTestCase.assertEquals((int)10, (int)results.size());
        long t0 = System.currentTimeMillis();
        while (true) {
            results = (List)queryRunner.query(connection, "SELECT * FROM TEST_OUT", (ResultSetHandler)new ArrayListHandler());
            this.logger.info((Object)("Results found: " + results.size()));
            if (results.size() >= 10) break;
            results = (List)queryRunner.query(connection, "SELECT * FROM TEST WHERE TYPE = 2", (ResultSetHandler)new ArrayListHandler());
            this.logger.info((Object)("Locked records found: " + results.size()));
            JdbcBridgeFunctionalTestCase.assertTrue((10 >= results.size() ? 1 : 0) != 0);
            results = (List)queryRunner.query(connection, "SELECT * FROM TEST WHERE TYPE = 1", (ResultSetHandler)new ArrayListHandler());
            this.logger.info((Object)("Original records found: " + results.size()));
            JdbcBridgeFunctionalTestCase.assertTrue((10 >= results.size() ? 1 : 0) != 0);
            JdbcBridgeFunctionalTestCase.assertTrue((System.currentTimeMillis() - t0 < 20000L ? 1 : 0) != 0);
            Thread.sleep(500L);
        }
    }
}

