/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.functional;

import java.util.Calendar;
import java.util.Date;
import org.apache.commons.dbutils.QueryRunner;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.transport.PropertyScope;
import org.mule.transport.jdbc.functional.AbstractJdbcFunctionalTestCase;
import org.mule.util.DateUtils;

public class IdempotencyTestCase
extends AbstractJdbcFunctionalTestCase {
    public void testIdempotencySequential() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        int id = Integer.valueOf(DateUtils.formatTimeStamp((Date)Calendar.getInstance().getTime(), (String)"hhmmss"));
        String valueExpression = DateUtils.formatTimeStamp((Date)Calendar.getInstance().getTime(), (String)"ssmmhh");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"hi", muleContext);
        message.setProperty("originalId", (Object)id, PropertyScope.OUTBOUND);
        message.setProperty("valueId", (Object)valueExpression, PropertyScope.OUTBOUND);
        client.dispatch("vm://in", (MuleMessage)message);
        MuleMessage requestMessage = client.request("vm://forProcessing", 5000L);
        IdempotencyTestCase.assertNotNull((Object)requestMessage);
        message = new DefaultMuleMessage((Object)"hi", muleContext);
        message.setProperty("originalId", (Object)id, PropertyScope.OUTBOUND);
        message.setProperty("valueId", (Object)valueExpression, PropertyScope.OUTBOUND);
        client.send("vm://in", (MuleMessage)message);
        requestMessage = client.request("vm://duplicated", 5000L);
        IdempotencyTestCase.assertNotNull((Object)requestMessage);
    }

    @Override
    protected String getConfigResources() {
        return super.getConfigResources() + ",jdbc-store.xml";
    }

    @Override
    protected void createTable() throws Exception {
        super.createTable();
        QueryRunner qr = this.jdbcConnector.getQueryRunner();
        qr.update(this.jdbcConnector.getConnection(), "CREATE TABLE IDS(K VARCHAR(255) NOT NULL PRIMARY KEY, VALUE VARCHAR(255))");
    }

    @Override
    protected void deleteTable() throws Exception {
        super.deleteTable();
        QueryRunner qr = this.jdbcConnector.getQueryRunner();
        qr.update(this.jdbcConnector.getConnection(), "DELETE FROM IDS");
    }
}

