/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.functional;

import java.util.HashMap;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ArrayHandler;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.transport.jdbc.functional.AbstractJdbcFunctionalTestCase;

public class JdbcFunctionalTestCase
extends AbstractJdbcFunctionalTestCase {
    public JdbcFunctionalTestCase() {
        this.setPopulateTestData(false);
    }

    @Override
    protected String getConfigResources() {
        return super.getConfigResources() + ",jdbc-functional-config.xml";
    }

    public void testDirectSql() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage message = client.request("jdbc://SELECT * FROM TEST", 1000L);
        JdbcFunctionalTestCase.assertResultSetEmpty(message);
        QueryRunner qr = this.jdbcConnector.getQueryRunner();
        int updated = qr.update(this.jdbcConnector.getConnection(), "INSERT INTO TEST(TYPE, DATA) VALUES (1, 'Test Message')");
        JdbcFunctionalTestCase.assertEquals((int)1, (int)updated);
        message = client.request("jdbc://SELECT * FROM TEST", 1000L);
        JdbcFunctionalTestCase.assertResultSetNotEmpty(message);
    }

    public void testSend() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        client.send("jdbc://writeTest?type=2", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        QueryRunner qr = this.jdbcConnector.getQueryRunner();
        Object[] obj2 = (Object[])qr.query(this.jdbcConnector.getConnection(), "SELECT DATA FROM TEST WHERE TYPE = 2", (ResultSetHandler)new ArrayHandler());
        JdbcFunctionalTestCase.assertNotNull((Object)obj2);
        JdbcFunctionalTestCase.assertEquals((int)1, (int)obj2.length);
        JdbcFunctionalTestCase.assertEquals((Object)"Test Message", (Object)obj2[0]);
    }

    public void testSendMap() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("data", "Test Message");
        client.send("jdbc://writeMap?type=2", (MuleMessage)new DefaultMuleMessage(map, muleContext));
        QueryRunner qr = this.jdbcConnector.getQueryRunner();
        Object[] obj2 = (Object[])qr.query(this.jdbcConnector.getConnection(), "SELECT DATA FROM TEST WHERE TYPE = 2", (ResultSetHandler)new ArrayHandler());
        JdbcFunctionalTestCase.assertNotNull((Object)obj2);
        JdbcFunctionalTestCase.assertEquals((int)1, (int)obj2.length);
        JdbcFunctionalTestCase.assertEquals((Object)"Test Message", (Object)obj2[0]);
    }

    public void testReceive() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage message = client.request("jdbc://getTest?type=1", 1000L);
        JdbcFunctionalTestCase.assertResultSetEmpty(message);
        QueryRunner qr = this.jdbcConnector.getQueryRunner();
        int updated = qr.update(this.jdbcConnector.getConnection(), "INSERT INTO TEST(TYPE, DATA, ACK, RESULT) VALUES (1, 'Test Message', NULL, NULL)");
        JdbcFunctionalTestCase.assertEquals((int)1, (int)updated);
        message = client.request("jdbc://getTest?type=1", 1000L);
        JdbcFunctionalTestCase.assertResultSetNotEmpty(message);
    }

    public void testReceiveAndSend() throws Exception {
        QueryRunner qr = this.jdbcConnector.getQueryRunner();
        qr.update(this.jdbcConnector.getConnection(), "INSERT INTO TEST(TYPE, DATA, ACK, RESULT) VALUES (1, 'Test Message', NULL, NULL)");
        long t0 = System.currentTimeMillis();
        while (System.currentTimeMillis() - t0 < 20000L) {
            Object[] rs = (Object[])qr.query(this.jdbcConnector.getConnection(), "SELECT COUNT(*) FROM TEST WHERE TYPE = 2", (ResultSetHandler)new ArrayHandler());
            JdbcFunctionalTestCase.assertNotNull((Object)rs);
            JdbcFunctionalTestCase.assertEquals((int)1, (int)rs.length);
            if (((Number)rs[0]).intValue() > 0) break;
            Thread.sleep(100L);
        }
        Object[] obj2 = (Object[])qr.query(this.jdbcConnector.getConnection(), "SELECT DATA FROM TEST WHERE TYPE = 2", (ResultSetHandler)new ArrayHandler());
        JdbcFunctionalTestCase.assertNotNull((Object)obj2);
        JdbcFunctionalTestCase.assertEquals((int)1, (int)obj2.length);
        JdbcFunctionalTestCase.assertEquals((Object)"Test Message Received", (Object)obj2[0]);
    }
}

