/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.reliability;

import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ArrayHandler;
import org.mule.tck.probe.Probe;
import org.mule.transport.jdbc.reliability.InboundMessageLossTestCase;

public class InboundMessageLossFlowTestCase
extends InboundMessageLossTestCase {
    @Override
    protected String getConfigResources() {
        return "reliability/jdbc-connector.xml, reliability/inbound-message-loss-flow.xml";
    }

    @Override
    public void testTransformerException() throws Exception {
        InboundMessageLossFlowTestCase.assertEquals((int)1, (int)this.qr.update(this.jdbcConnector.getConnection(), "INSERT INTO TEST(TYPE, DATA, ACK, RESULT) VALUES (2, 'Test Message', NULL, NULL)"));
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                try {
                    Object[] queryResult = (Object[])InboundMessageLossFlowTestCase.this.qr.query(InboundMessageLossFlowTestCase.this.jdbcConnector.getConnection(), "SELECT DATA FROM TEST WHERE TYPE = 2 AND ACK IS NULL", (ResultSetHandler)new ArrayHandler());
                    return queryResult == null;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public String describeFailure() {
                return "Row should be acknowledged (marked read)";
            }
        });
    }

    @Override
    public void testRouterException() throws Exception {
        InboundMessageLossFlowTestCase.assertEquals((int)1, (int)this.qr.update(this.jdbcConnector.getConnection(), "INSERT INTO TEST(TYPE, DATA, ACK, RESULT) VALUES (3, 'Test Message', NULL, NULL)"));
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                try {
                    Object[] queryResult = (Object[])InboundMessageLossFlowTestCase.this.qr.query(InboundMessageLossFlowTestCase.this.jdbcConnector.getConnection(), "SELECT DATA FROM TEST WHERE TYPE = 3 AND ACK IS NULL", (ResultSetHandler)new ArrayHandler());
                    return queryResult == null;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public String describeFailure() {
                return "Row should be acknowledged (marked read)";
            }
        });
    }
}

