/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.reliability;

import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ArrayHandler;
import org.mule.exception.DefaultSystemExceptionStrategy;
import org.mule.routing.filters.WildcardFilter;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.probe.Prober;
import org.mule.transport.jdbc.functional.AbstractJdbcFunctionalTestCase;

public class InboundMessageLossTestCase
extends AbstractJdbcFunctionalTestCase {
    protected Prober prober = new PollingProber(10000L, 100L);
    protected QueryRunner qr;

    public InboundMessageLossTestCase() {
        this.setPopulateTestData(false);
    }

    @Override
    protected String getConfigResources() {
        return "reliability/jdbc-connector.xml, reliability/inbound-message-loss.xml";
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        ((DefaultSystemExceptionStrategy)muleContext.getExceptionListener()).setRollbackTxFilter(new WildcardFilter("*"));
        this.qr = this.jdbcConnector.getQueryRunner();
    }

    public void testNoException() throws Exception {
        InboundMessageLossTestCase.assertEquals((int)1, (int)this.qr.update(this.jdbcConnector.getConnection(), "INSERT INTO TEST(TYPE, DATA, ACK, RESULT) VALUES (1, 'Test Message', NULL, NULL)"));
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                try {
                    Object[] queryResult = (Object[])InboundMessageLossTestCase.this.qr.query(InboundMessageLossTestCase.this.jdbcConnector.getConnection(), "SELECT DATA FROM TEST WHERE TYPE = 1 AND ACK IS NULL", (ResultSetHandler)new ArrayHandler());
                    return queryResult == null;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public String describeFailure() {
                return "Row should be acknowledged (marked read)";
            }
        });
    }

    public void testTransformerException() throws Exception {
        InboundMessageLossTestCase.assertEquals((int)1, (int)this.qr.update(this.jdbcConnector.getConnection(), "INSERT INTO TEST(TYPE, DATA, ACK, RESULT) VALUES (2, 'Test Message', NULL, NULL)"));
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                try {
                    Object[] queryResult = (Object[])InboundMessageLossTestCase.this.qr.query(InboundMessageLossTestCase.this.jdbcConnector.getConnection(), "SELECT DATA FROM TEST WHERE TYPE = 2 AND ACK IS NULL", (ResultSetHandler)new ArrayHandler());
                    return queryResult != null && queryResult.length == 1;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public String describeFailure() {
                return "Row should not be acknowledged (marked read)";
            }
        });
    }

    public void testRouterException() throws Exception {
        InboundMessageLossTestCase.assertEquals((int)1, (int)this.qr.update(this.jdbcConnector.getConnection(), "INSERT INTO TEST(TYPE, DATA, ACK, RESULT) VALUES (3, 'Test Message', NULL, NULL)"));
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                try {
                    Object[] queryResult = (Object[])InboundMessageLossTestCase.this.qr.query(InboundMessageLossTestCase.this.jdbcConnector.getConnection(), "SELECT DATA FROM TEST WHERE TYPE = 3 AND ACK IS NULL", (ResultSetHandler)new ArrayHandler());
                    return queryResult != null && queryResult.length == 1;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public String describeFailure() {
                return "Row should not be acknowledged (marked read)";
            }
        });
    }

    public void testComponentException() throws Exception {
        InboundMessageLossTestCase.assertEquals((int)1, (int)this.qr.update(this.jdbcConnector.getConnection(), "INSERT INTO TEST(TYPE, DATA, ACK, RESULT) VALUES (4, 'Test Message', NULL, NULL)"));
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                try {
                    Object[] queryResult = (Object[])InboundMessageLossTestCase.this.qr.query(InboundMessageLossTestCase.this.jdbcConnector.getConnection(), "SELECT DATA FROM TEST WHERE TYPE = 4 AND ACK IS NULL", (ResultSetHandler)new ArrayHandler());
                    return queryResult == null;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public String describeFailure() {
                return "Row should be acknowledged (marked read)";
            }
        });
    }
}

