/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.config;

import org.enhydra.jdbc.standard.StandardDataSource;
import org.mule.tck.FunctionalTestCase;

public class JdbcDataSourceNamespaceHandlerTestCase
extends FunctionalTestCase {
    public JdbcDataSourceNamespaceHandlerTestCase() {
        this.setStartContext(false);
    }

    protected String getConfigResources() {
        return "jdbc-data-source-namespace-config.xml";
    }

    public void testSingleton() {
        StandardDataSource ds1 = this.lookupDataSource("default-oracle");
        StandardDataSource ds2 = this.lookupDataSource("default-oracle");
        JdbcDataSourceNamespaceHandlerTestCase.assertSame((Object)ds1, (Object)ds2);
    }

    public void testCustomDataSourceProperties() {
        StandardDataSource source = this.lookupDataSource("custom-ds-properties");
        JdbcDataSourceNamespaceHandlerTestCase.assertEquals((int)8, (int)source.getTransactionIsolation());
        JdbcDataSourceNamespaceHandlerTestCase.assertEquals((int)42, (int)source.getLoginTimeout());
    }

    public void testOracleDefaults() {
        StandardDataSource source = this.lookupDataSource("default-oracle");
        JdbcDataSourceNamespaceHandlerTestCase.assertEquals((String)"jdbc:oracle:thin:@localhost:1521:orcl", (String)source.getUrl());
        JdbcDataSourceNamespaceHandlerTestCase.assertEquals((String)"oracle.jdbc.driver.OracleDriver", (String)source.getDriverName());
        JdbcDataSourceNamespaceHandlerTestCase.assertEquals((int)-1, (int)source.getTransactionIsolation());
        JdbcDataSourceNamespaceHandlerTestCase.assertEquals((String)"scott", (String)source.getUser());
        JdbcDataSourceNamespaceHandlerTestCase.assertEquals((String)"tiger", (String)source.getPassword());
    }

    public void testOracleCustomUrl() {
        StandardDataSource source = this.lookupDataSource("custom-url-oracle");
        JdbcDataSourceNamespaceHandlerTestCase.assertEquals((String)"jdbc:oracle:thin:@some-other-host:1522:mule", (String)source.getUrl());
    }

    public void testOracleCustomHost() {
        StandardDataSource source = this.lookupDataSource("custom-host-oracle");
        JdbcDataSourceNamespaceHandlerTestCase.assertEquals((String)"jdbc:oracle:thin:@some-other-host:1521:orcl", (String)source.getUrl());
    }

    public void testOracleCustomPort() {
        StandardDataSource source = this.lookupDataSource("custom-port-oracle");
        JdbcDataSourceNamespaceHandlerTestCase.assertEquals((String)"jdbc:oracle:thin:@localhost:1522:orcl", (String)source.getUrl());
    }

    public void testOracleCustomInstance() {
        StandardDataSource source = this.lookupDataSource("custom-instance-oracle");
        JdbcDataSourceNamespaceHandlerTestCase.assertEquals((String)"jdbc:oracle:thin:@localhost:1521:mule", (String)source.getUrl());
    }

    public void testMysqlDefaults() {
        StandardDataSource source = this.lookupDataSource("default-mysql");
        JdbcDataSourceNamespaceHandlerTestCase.assertEquals((String)"jdbc:mysql://localhost/mule", (String)source.getUrl());
        JdbcDataSourceNamespaceHandlerTestCase.assertEquals((String)"com.mysql.jdbc.Driver", (String)source.getDriverName());
        JdbcDataSourceNamespaceHandlerTestCase.assertEquals((String)"mysql", (String)source.getUser());
        JdbcDataSourceNamespaceHandlerTestCase.assertEquals((String)"secret", (String)source.getPassword());
    }

    public void testMysqlCustomUrl() {
        StandardDataSource source = this.lookupDataSource("custom-url-mysql");
        JdbcDataSourceNamespaceHandlerTestCase.assertEquals((String)"jdbc:mysql://mule-db-host:3306/mule", (String)source.getUrl());
    }

    public void testMysqlCustomHost() {
        StandardDataSource source = this.lookupDataSource("custom-host-mysql");
        JdbcDataSourceNamespaceHandlerTestCase.assertEquals((String)"jdbc:mysql://some-other-host/mule", (String)source.getUrl());
    }

    public void testMysqlCustomPort() {
        StandardDataSource source = this.lookupDataSource("custom-port-mysql");
        JdbcDataSourceNamespaceHandlerTestCase.assertEquals((String)"jdbc:mysql://localhost:4242/mule", (String)source.getUrl());
    }

    public void testPostgresqlDefaults() {
        StandardDataSource source = this.lookupDataSource("default-postgresql");
        JdbcDataSourceNamespaceHandlerTestCase.assertEquals((String)"jdbc:postgresql://localhost/mule", (String)source.getUrl());
        JdbcDataSourceNamespaceHandlerTestCase.assertEquals((String)"org.postgresql.Driver", (String)source.getDriverName());
        JdbcDataSourceNamespaceHandlerTestCase.assertEquals((String)"postgres", (String)source.getUser());
        JdbcDataSourceNamespaceHandlerTestCase.assertEquals((String)"secret", (String)source.getPassword());
    }

    public void testPostgresqlCustomUrl() {
        StandardDataSource source = this.lookupDataSource("custom-url-postgresql");
        JdbcDataSourceNamespaceHandlerTestCase.assertEquals((String)"jdbc:postgresql://mule-db-host:5432/mule", (String)source.getUrl());
    }

    public void testPostgresqlCustomHost() {
        StandardDataSource source = this.lookupDataSource("custom-host-postgresql");
        JdbcDataSourceNamespaceHandlerTestCase.assertEquals((String)"jdbc:postgresql://some-other-host/mule", (String)source.getUrl());
    }

    public void testPostgresqlCustomPort() {
        StandardDataSource source = this.lookupDataSource("custom-port-postgresql");
        JdbcDataSourceNamespaceHandlerTestCase.assertEquals((String)"jdbc:postgresql://localhost:5433/mule", (String)source.getUrl());
    }

    public void testDerbyDefaults() {
        StandardDataSource source = this.lookupDataSource("default-derby");
        JdbcDataSourceNamespaceHandlerTestCase.assertEquals((String)"jdbc:derby:memory:mule", (String)source.getUrl());
        JdbcDataSourceNamespaceHandlerTestCase.assertEquals((String)"org.apache.derby.jdbc.EmbeddedDriver", (String)source.getDriverName());
    }

    public void testDerbyCustomUrl() {
        StandardDataSource source = this.lookupDataSource("custom-url-derby");
        JdbcDataSourceNamespaceHandlerTestCase.assertEquals((String)"jdbc:derby:muleEmbedded", (String)source.getUrl());
    }

    public void testDerbyCreateDatabase() {
        StandardDataSource source = this.lookupDataSource("create-database-derby");
        JdbcDataSourceNamespaceHandlerTestCase.assertEquals((String)"jdbc:derby:memory:mule;create=true", (String)source.getUrl());
    }

    private StandardDataSource lookupDataSource(String key) {
        Object object = muleContext.getRegistry().lookupObject(key);
        JdbcDataSourceNamespaceHandlerTestCase.assertNotNull((Object)object);
        JdbcDataSourceNamespaceHandlerTestCase.assertTrue((boolean)(object instanceof StandardDataSource));
        return (StandardDataSource)object;
    }
}

