/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.config.ExceptionReader;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.retry.RetryContext;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionException;
import org.mule.api.transport.Connectable;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageReceiver;
import org.mule.config.ExceptionHelper;
import org.mule.config.i18n.MessageFactory;
import org.mule.transaction.TransactionCoordination;
import org.mule.transport.AbstractConnector;
import org.mule.transport.ConnectException;
import org.mule.transport.jdbc.ColumnAliasRowProcessor;
import org.mule.transport.jdbc.ExtendedQueryRunner;
import org.mule.transport.jdbc.JdbcUtils;
import org.mule.transport.jdbc.SQLExceptionReader;
import org.mule.transport.jdbc.sqlstrategy.DefaultSqlStatementStrategyFactory;
import org.mule.transport.jdbc.sqlstrategy.SqlStatementStrategyFactory;
import org.mule.transport.jdbc.xa.DataSourceWrapper;
import org.mule.util.StringUtils;
import org.mule.util.TemplateParser;

public class JdbcConnector
extends AbstractConnector {
    public static final String JDBC = "jdbc";
    public static final String PROPERTY_POLLING_FREQUENCY = "pollingFrequency";
    public static final long DEFAULT_POLLING_FREQUENCY = 1000L;
    private static final Pattern STATEMENT_ARGS = TemplateParser.WIGGLY_MULE_TEMPLATE_PATTERN;
    private SqlStatementStrategyFactory sqlStatementStrategyFactory = new DefaultSqlStatementStrategyFactory();
    protected long pollingFrequency = 0L;
    protected Map queries;
    protected DataSource dataSource;
    protected ResultSetHandler resultSetHandler;
    protected QueryRunner queryRunner;
    private int queryTimeout;
    protected boolean transactionPerMessage = true;

    public JdbcConnector(MuleContext context) {
        super(context);
    }

    protected void doInitialise() throws InitialisationException {
        this.createMultipleTransactedReceivers = false;
        if (this.dataSource == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage((String)"Missing data source"), (Initialisable)this);
        }
        if (this.resultSetHandler == null) {
            this.resultSetHandler = new MapListHandler((RowProcessor)new ColumnAliasRowProcessor());
        }
        if (this.queryRunner == null) {
            this.queryRunner = this.queryTimeout >= 0 ? new ExtendedQueryRunner(this.dataSource, this.queryTimeout) : new QueryRunner();
        }
    }

    public MessageReceiver createReceiver(FlowConstruct flowConstruct, InboundEndpoint endpoint) throws Exception {
        String tempPolling;
        Map props = endpoint.getProperties();
        if (props != null && (tempPolling = (String)props.get(PROPERTY_POLLING_FREQUENCY)) != null) {
            this.pollingFrequency = Long.parseLong(tempPolling);
        }
        if (this.pollingFrequency <= 0L) {
            this.pollingFrequency = 1000L;
        }
        Object[] params = this.getReadAndAckStatements((ImmutableEndpoint)endpoint);
        return this.getServiceDescriptor().createMessageReceiver((Connector)this, flowConstruct, endpoint, params);
    }

    public String[] getReadAndAckStatements(ImmutableEndpoint endpoint) {
        String ackStmt;
        String str = (String)endpoint.getProperty((Object)"sql");
        String readStmt = str != null ? str : endpoint.getEndpointURI().getAddress();
        str = (String)endpoint.getProperty((Object)"ack");
        if (str != null) {
            ackStmt = str;
            if ((str = this.getQuery(endpoint, ackStmt)) != null) {
                ackStmt = str;
            }
            ackStmt = ackStmt.trim();
        } else {
            ackStmt = readStmt + ".ack";
            str = this.getQuery(endpoint, ackStmt);
            ackStmt = str != null ? str.trim() : null;
        }
        str = this.getQuery(endpoint, readStmt);
        if (str != null) {
            readStmt = str;
        }
        if (readStmt == null) {
            throw new IllegalArgumentException("Read statement should not be null");
        }
        if (!"select".equalsIgnoreCase((readStmt = readStmt.trim()).substring(0, 6)) && !"call".equalsIgnoreCase(readStmt.substring(0, 4))) {
            throw new IllegalArgumentException("Read statement should be a select sql statement or a stored procedure");
        }
        if (!(ackStmt == null || "insert".equalsIgnoreCase(ackStmt.substring(0, 6)) || "update".equalsIgnoreCase(ackStmt.substring(0, 6)) || "delete".equalsIgnoreCase(ackStmt.substring(0, 6)))) {
            throw new IllegalArgumentException("Ack statement should be an insert / update / delete sql statement");
        }
        return new String[]{readStmt, ackStmt};
    }

    public String getQuery(ImmutableEndpoint endpoint, String stmt) {
        Object queries;
        Object query = null;
        if (endpoint != null && endpoint.getProperties() != null && (queries = endpoint.getProperties().get("queries")) instanceof Map) {
            query = ((Map)queries).get(stmt);
        }
        if (query == null && this.queries != null) {
            query = this.queries.get(stmt);
        }
        return query == null ? null : query.toString();
    }

    public Connection getConnection() throws Exception {
        Connection con;
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        if (tx != null && tx.hasResource((Object)this.dataSource)) {
            this.logger.debug((Object)("Retrieving connection from current transaction: " + tx));
            return (Connection)tx.getResource((Object)this.dataSource);
        }
        this.logger.debug((Object)"Retrieving new connection from data source");
        try {
            con = this.dataSource.getConnection();
        }
        catch (Exception e) {
            throw new ConnectException((Throwable)e, (Connectable)this);
        }
        if (tx != null) {
            this.logger.debug((Object)("Binding connection " + con + " to current transaction: " + tx));
            try {
                tx.bindResource((Object)this.dataSource, (Object)con);
            }
            catch (TransactionException e) {
                JdbcUtils.close(con);
                throw new RuntimeException("Could not bind connection to current transaction: " + tx, e);
            }
        }
        return con;
    }

    public boolean isTransactionPerMessage() {
        return this.transactionPerMessage;
    }

    public void setTransactionPerMessage(boolean transactionPerMessage) {
        this.transactionPerMessage = transactionPerMessage;
        if (!transactionPerMessage) {
            this.logger.warn((Object)"transactionPerMessage property is set to false so setting createMultipleTransactedReceivers to false also to prevent creation of multiple JdbcMessageReceivers");
            this.setCreateMultipleTransactedReceivers(transactionPerMessage);
        }
    }

    public String parseStatement(String stmt, List params) {
        if (stmt == null) {
            return stmt;
        }
        Matcher m = STATEMENT_ARGS.matcher(stmt);
        StringBuffer sb = new StringBuffer(200);
        while (m.find()) {
            String key = m.group();
            m.appendReplacement(sb, "?");
            if (key.equals("#[payload]")) {
                this.logger.error((Object)"invalid expression template #[payload]. It should be replaced with #[payload:] to conform with the correct expression syntax. Mule has replaced this for you, but may not in future versions.");
                key = "#[payload:]";
            }
            params.add(key);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public Object[] getParams(ImmutableEndpoint endpoint, List paramNames, MuleMessage message, String query) throws Exception {
        Object[] params = new Object[paramNames.size()];
        for (int i = 0; i < paramNames.size(); ++i) {
            Object value;
            String param = (String)paramNames.get(i);
            params[i] = value = this.getParamValue(endpoint, message, param);
        }
        return params;
    }

    protected Object getParamValue(ImmutableEndpoint endpoint, MuleMessage message, String param) {
        Object value = null;
        boolean foundValue = false;
        boolean validExpression = this.muleContext.getExpressionManager().isValidExpression(param);
        if (message != null && validExpression) {
            value = this.muleContext.getExpressionManager().evaluate(param, message);
            boolean bl = foundValue = value != null;
        }
        if (!foundValue) {
            String name = this.getNameFromParam(param);
            if (!validExpression) {
                this.logger.warn((Object)MessageFormat.format("Config is using the legacy param format {0} (no evaluator defined). This expression can be replaced with {1}header:{2}{3}", param, "#[", name, "]"));
            }
            value = endpoint.getProperty((Object)name);
        }
        return value;
    }

    protected String getNameFromParam(String param) {
        return param.substring(2, param.length() - 1);
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RetryContext validateConnection(RetryContext retryContext) {
        try {
            Connection con = this.getConnection();
            if (con != null) {
                con.close();
            }
            retryContext.setOk();
        }
        catch (Exception ex) {
            retryContext.setFailed((Throwable)ex);
        }
        finally {
            Object con = null;
        }
        return retryContext;
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }

    public String getProtocol() {
        return JDBC;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource instanceof XADataSource ? new DataSourceWrapper((XADataSource)((Object)dataSource)) : dataSource;
    }

    public ResultSetHandler getResultSetHandler() {
        return this.resultSetHandler;
    }

    public void setResultSetHandler(ResultSetHandler resultSetHandler) {
        this.resultSetHandler = resultSetHandler;
    }

    public QueryRunner getQueryRunnerFor(ImmutableEndpoint endpoint) {
        String queryTimeoutAsString = (String)endpoint.getProperty((Object)"queryTimeout");
        Integer queryTimeout = -1;
        try {
            queryTimeout = Integer.valueOf(queryTimeoutAsString);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (queryTimeout >= 0) {
            ExtendedQueryRunner extendedQueryRunner = new ExtendedQueryRunner(this.queryRunner.getDataSource(), queryTimeout);
            return extendedQueryRunner;
        }
        return this.queryRunner;
    }

    public QueryRunner getQueryRunner() {
        return this.queryRunner;
    }

    public void setQueryRunner(QueryRunner queryRunner) {
        this.queryRunner = queryRunner;
    }

    public long getPollingFrequency() {
        return this.pollingFrequency;
    }

    public void setPollingFrequency(long pollingFrequency) {
        this.pollingFrequency = pollingFrequency;
    }

    public Map getQueries() {
        return this.queries;
    }

    public void setQueries(Map queries) {
        this.queries = queries;
    }

    public SqlStatementStrategyFactory getSqlStatementStrategyFactory() {
        return this.sqlStatementStrategyFactory;
    }

    public void setSqlStatementStrategyFactory(SqlStatementStrategyFactory sqlStatementStrategyFactory) {
        this.sqlStatementStrategyFactory = sqlStatementStrategyFactory;
    }

    public String getStatement(ImmutableEndpoint endpoint) {
        String writeStmt = endpoint.getEndpointURI().getAddress();
        String str = this.getQuery(endpoint, writeStmt);
        if (str != null) {
            writeStmt = str;
        }
        if (StringUtils.isBlank((String)(writeStmt = StringUtils.trimToEmpty((String)writeStmt)))) {
            throw new IllegalArgumentException("Missing statement");
        }
        return writeStmt;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    static {
        ExceptionHelper.registerExceptionReader((ExceptionReader)new SQLExceptionReader());
    }
}

