/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.config;

import org.mule.config.spring.handlers.AbstractMuleNamespaceHandler;
import org.mule.config.spring.parsers.ClassOrRefDefinitionParser;
import org.mule.config.spring.parsers.MuleDefinitionParser;
import org.mule.config.spring.parsers.PreProcessor;
import org.mule.config.spring.parsers.collection.ChildSingletonMapDefinitionParser;
import org.mule.config.spring.parsers.delegate.ParentContextDefinitionParser;
import org.mule.config.spring.parsers.generic.ChildDefinitionParser;
import org.mule.config.spring.parsers.generic.ParentDefinitionParser;
import org.mule.config.spring.parsers.processors.CheckExclusiveAttributes;
import org.mule.config.spring.parsers.specific.ObjectFactoryWrapper;
import org.mule.config.spring.parsers.specific.TransactionDefinitionParser;
import org.mule.config.spring.parsers.specific.properties.NestedMapDefinitionParser;
import org.mule.transport.jdbc.JdbcConnector;
import org.mule.transport.jdbc.JdbcTransactionFactory;
import org.mule.transport.jdbc.config.AbstractDataSourceFactoryBean;
import org.mule.transport.jdbc.config.CheckDatabaseOrUrl;
import org.mule.transport.jdbc.config.DataSourceDefinitionParser;
import org.mule.transport.jdbc.config.DerbyDataSourceFactoryBean;
import org.mule.transport.jdbc.config.MysqlDataSourceFactoryBean;
import org.mule.transport.jdbc.config.OracleDataSourceFactoryBean;
import org.mule.transport.jdbc.config.PostgresqlDataSourceFactoryBean;
import org.mule.transport.jdbc.store.JdbcObjectStore;
import org.springframework.beans.factory.xml.BeanDefinitionParser;

public class JdbcNamespaceHandler
extends AbstractMuleNamespaceHandler {
    public static final String QUERY_KEY = "queryKey";
    public static final String[] ADDRESS_ATTRIBUTES = new String[]{"queryKey"};
    public static final String SQL_STATEMENT_FACTORY_PROPERTY = "sqlStatementStrategyFactory";

    public void init() {
        this.registerStandardTransportEndpoints("jdbc", ADDRESS_ATTRIBUTES).addAlias(QUERY_KEY, "path");
        this.registerConnectorDefinitionParser(JdbcConnector.class);
        this.registerBeanDefinitionParser("dataSource", (BeanDefinitionParser)new ObjectFactoryWrapper("dataSourceFactory"));
        this.registerBeanDefinitionParser(SQL_STATEMENT_FACTORY_PROPERTY, (BeanDefinitionParser)new ClassOrRefDefinitionParser(SQL_STATEMENT_FACTORY_PROPERTY));
        ChildSingletonMapDefinitionParser connectorQuery = new ChildSingletonMapDefinitionParser("query");
        NestedMapDefinitionParser endpointQuery = new NestedMapDefinitionParser("properties", "queries");
        endpointQuery.addCollection("properties");
        this.registerMuleBeanDefinitionParser("query", (MuleDefinitionParser)new ParentContextDefinitionParser("connector", (MuleDefinitionParser)connectorQuery).otherwise((MuleDefinitionParser)endpointQuery));
        this.registerBeanDefinitionParser("extractors", (BeanDefinitionParser)new ParentDefinitionParser());
        this.registerBeanDefinitionParser("transaction", (BeanDefinitionParser)new TransactionDefinitionParser(JdbcTransactionFactory.class));
        this.registerBeanDefinitionParser("object-store", (BeanDefinitionParser)new ChildDefinitionParser("store", JdbcObjectStore.class));
        this.registerDataSourceDefinitionParsers();
    }

    protected void registerDataSourceDefinitionParsers() {
        this.registerDerbyDataSourceDefinitionParser();
        this.registerMysqlDataSourceDefinitionParser();
        this.registerOracleDataSourceDefinitionParser();
        this.registerPostgresqlDataSourceDefinitionParser();
    }

    protected void registerDerbyDataSourceDefinitionParser() {
        DataSourceDefinitionParser parser = new DataSourceDefinitionParser(DerbyDataSourceFactoryBean.class);
        parser.registerPreProcessor(new CheckDatabaseOrUrl());
        this.registerBeanDefinitionParser("derby-data-source", (BeanDefinitionParser)parser);
    }

    protected void registerMysqlDataSourceDefinitionParser() {
        this.registerHostAndPortTypeDefinitionParser(MysqlDataSourceFactoryBean.class, "mysql-data-source");
    }

    protected void registerOracleDataSourceDefinitionParser() {
        DataSourceDefinitionParser parser = new DataSourceDefinitionParser(OracleDataSourceFactoryBean.class);
        String[][] attributeGroups = new String[][]{{"url"}, {"host", "port", "instance"}};
        CheckExclusiveAttributes attributeCheck = new CheckExclusiveAttributes(attributeGroups);
        parser.registerPreProcessor((PreProcessor)attributeCheck);
        this.registerBeanDefinitionParser("oracle-data-source", (BeanDefinitionParser)parser);
    }

    protected void registerPostgresqlDataSourceDefinitionParser() {
        this.registerHostAndPortTypeDefinitionParser(PostgresqlDataSourceFactoryBean.class, "postgresql-data-source");
    }

    protected void registerHostAndPortTypeDefinitionParser(Class<? extends AbstractDataSourceFactoryBean> poolFactoryClass, String elementName) {
        DataSourceDefinitionParser parser = new DataSourceDefinitionParser(poolFactoryClass);
        String[][] attributeGroups = new String[][]{{"url"}, {"host", "port"}};
        CheckExclusiveAttributes attributeCheck = new CheckExclusiveAttributes(attributeGroups);
        parser.registerPreProcessor((PreProcessor)attributeCheck);
        parser.registerPreProcessor(new CheckDatabaseOrUrl());
        this.registerBeanDefinitionParser(elementName, (BeanDefinitionParser)parser);
    }
}

