/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.functional;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEvent;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.context.notification.TransactionNotificationListener;
import org.mule.construct.Flow;
import org.mule.context.notification.TransactionNotification;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transport.jdbc.functional.AbstractJdbcFunctionalTestCase;
import org.mule.util.concurrent.Latch;

public class JdbcTxNotSupportedTestCase
extends AbstractJdbcFunctionalTestCase {
    public JdbcTxNotSupportedTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList(new Object[][]{{AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, AbstractJdbcFunctionalTestCase.getConfig() + ",jdbc-tx-not-supported-config.xml"}});
    }

    @Before
    public void setUp() throws Exception {
        this.execSqlUpdate("delete from TEST");
    }

    @Test
    public void testEndpointNotSupported() throws Exception {
        final Latch transactionCommitLatch = new Latch();
        muleContext.registerListener((ServerNotificationListener)new TransactionNotificationListener<TransactionNotification>(){

            public void onNotification(TransactionNotification notification) {
                if (notification.getAction() == 1202) {
                    transactionCommitLatch.release();
                }
            }
        });
        this.execSqlUpdate("INSERT INTO TEST(TYPE, DATA, ACK, RESULT) VALUES(1, NULL, NULL, NULL)");
        if (!transactionCommitLatch.await(5L, TimeUnit.SECONDS)) {
            Assert.fail((String)"Transaction wasn't commited");
        }
        Assert.assertThat((Object)this.getCountWithType2(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.getCountWithType3(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void testEndpointNotSupportedFailingAtEnd() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("endpointNotSupportedFailingAtEnd");
        MuleEvent event = JdbcTxNotSupportedTestCase.getTestEvent((Object)"message", (FlowConstruct)flow);
        try {
            flow.process(event);
        }
        catch (Exception e) {
            // empty catch block
        }
        Integer countWithType2 = this.getCountWithType2();
        Integer countWithType3 = this.getCountWithType3();
        Assert.assertThat((Object)countWithType2, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)countWithType3, (Matcher)Is.is((Object)1));
    }
}

