/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.functional;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEvent;
import org.mule.api.construct.FlowConstruct;
import org.mule.construct.Flow;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transport.jdbc.functional.AbstractJdbcFunctionalTestCase;

public class JdbcTxTransactionalElementTestCase
extends AbstractJdbcFunctionalTestCase {
    public JdbcTxTransactionalElementTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList(new Object[][]{{AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, AbstractJdbcFunctionalTestCase.getConfig() + ",jdbc-tx-transactional-element.xml"}});
    }

    @Before
    public void setUp() throws Exception {
        this.execSqlUpdate("delete from TEST");
    }

    @Test
    public void testTransactional() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("transactional");
        MuleEvent event = JdbcTxTransactionalElementTestCase.getTestEvent((Object)"message", (FlowConstruct)flow);
        flow.process(event);
        Integer countWithType1 = this.getCountWithType1();
        Integer countWithType2 = this.getCountWithType2();
        Assert.assertThat((Object)countWithType1, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)countWithType2, (Matcher)Is.is((Object)1));
    }

    @Test
    public void testTransactionalFailInTheMiddle() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("transactionalFailInTheMiddle");
        MuleEvent event = JdbcTxTransactionalElementTestCase.getTestEvent((Object)"message", (FlowConstruct)flow);
        try {
            flow.process(event);
        }
        catch (Exception e) {
            // empty catch block
        }
        Integer countWithType1 = this.getCountWithType1();
        Integer countWithType2 = this.getCountWithType2();
        Assert.assertThat((Object)countWithType1, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)countWithType2, (Matcher)Is.is((Object)0));
    }

    @Test
    public void testTransactionalFailAtEnd() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("transactionalFailAtEnd");
        MuleEvent event = JdbcTxTransactionalElementTestCase.getTestEvent((Object)"message", (FlowConstruct)flow);
        try {
            flow.process(event);
        }
        catch (Exception e) {
            // empty catch block
        }
        Integer countWithType1 = this.getCountWithType1();
        Integer countWithType2 = this.getCountWithType2();
        Assert.assertThat((Object)countWithType1, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)countWithType2, (Matcher)Is.is((Object)0));
    }

    @Test
    public void testTransactionalFailAfterEnd() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("transactionalFailAfterEnd");
        MuleEvent event = JdbcTxTransactionalElementTestCase.getTestEvent((Object)"message", (FlowConstruct)flow);
        try {
            flow.process(event);
        }
        catch (Exception e) {
            // empty catch block
        }
        Integer countWithType1 = this.getCountWithType1();
        Integer countWithType2 = this.getCountWithType2();
        Assert.assertThat((Object)countWithType1, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)countWithType2, (Matcher)Is.is((Object)1));
    }

    @Test
    public void testTransactionalFailInTheMiddleWithCatchExceptionStrategy() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("transactionalFailInTheMiddleWithCatchExceptionStrategy");
        MuleEvent event = JdbcTxTransactionalElementTestCase.getTestEvent((Object)"message", (FlowConstruct)flow);
        flow.process(event);
        Integer countWithType1 = this.getCountWithType1();
        Integer countWithType2 = this.getCountWithType2();
        Assert.assertThat((Object)countWithType1, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)countWithType2, (Matcher)Is.is((Object)0));
    }

    @Test
    public void testTransactionalFailAtEndWithCatchExceptionStrategy() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("transactionalFailAtEndWithCatchExceptionStrategy");
        MuleEvent event = JdbcTxTransactionalElementTestCase.getTestEvent((Object)"message", (FlowConstruct)flow);
        flow.process(event);
        Integer countWithType1 = this.getCountWithType1();
        Integer countWithType2 = this.getCountWithType2();
        Assert.assertThat((Object)countWithType1, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)countWithType2, (Matcher)Is.is((Object)1));
    }

    @Test
    public void testTransactionalDoesntFailWithAnotherResourceType() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("transactionalDoesntFailWithAnotherResourceType");
        MuleEvent event = JdbcTxTransactionalElementTestCase.getTestEvent((Object)"message", (FlowConstruct)flow);
        flow.process(event);
        Integer countWithType1 = this.getCountWithType1();
        Integer countWithType2 = this.getCountWithType2();
        Integer countWithType3 = this.getCountWithType3();
        Assert.assertThat((Object)countWithType1, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)countWithType2, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)countWithType3, (Matcher)Is.is((Object)1));
    }

    @Test
    public void testTransactionalWithAnotherResourceTypeAndExceptionAtEnd() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("transactionalWithAnotherResourceTypeAndExceptionAtEnd");
        MuleEvent event = JdbcTxTransactionalElementTestCase.getTestEvent((Object)"message", (FlowConstruct)flow);
        try {
            flow.process(event);
        }
        catch (Exception e) {
            // empty catch block
        }
        Integer countWithType1 = this.getCountWithType1();
        Integer countWithType2 = this.getCountWithType2();
        Integer countWithType3 = this.getCountWithType3();
        Assert.assertThat((Object)countWithType1, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)countWithType2, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)countWithType3, (Matcher)Is.is((Object)1));
    }

    @Test
    public void testNestedTransactional() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("nestedTransactional");
        MuleEvent event = JdbcTxTransactionalElementTestCase.getTestEvent((Object)"message", (FlowConstruct)flow);
        flow.process(event);
        Integer countWithType1 = this.getCountWithType1();
        Integer countWithType2 = this.getCountWithType2();
        Assert.assertThat((Object)countWithType1, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)countWithType2, (Matcher)Is.is((Object)1));
    }

    @Test
    public void testNestedTransactionalFail() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("nestedTransactionalFail");
        MuleEvent event = JdbcTxTransactionalElementTestCase.getTestEvent((Object)"message", (FlowConstruct)flow);
        try {
            flow.process(event);
        }
        catch (Exception e) {
            // empty catch block
        }
        Integer countWithType1 = this.getCountWithType1();
        Integer countWithType2 = this.getCountWithType2();
        Assert.assertThat((Object)countWithType1, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)countWithType2, (Matcher)Is.is((Object)0));
    }

    @Test
    public void testNestedTransactionalFailWithCatch() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("nestedTransactionalFailWithCatch");
        MuleEvent event = JdbcTxTransactionalElementTestCase.getTestEvent((Object)"message", (FlowConstruct)flow);
        flow.process(event);
        Integer countWithType1 = this.getCountWithType1();
        Integer countWithType2 = this.getCountWithType2();
        Assert.assertThat((Object)countWithType1, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)countWithType2, (Matcher)Is.is((Object)1));
    }

    @Test
    public void testNestedTransactionalWithBeginOrJoin() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("nestedTransactionalWithBeginOrJoin");
        MuleEvent event = JdbcTxTransactionalElementTestCase.getTestEvent((Object)"message", (FlowConstruct)flow);
        flow.process(event);
        Integer countWithType1 = this.getCountWithType1();
        Integer countWithType2 = this.getCountWithType2();
        Assert.assertThat((Object)countWithType1, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)countWithType2, (Matcher)Is.is((Object)1));
    }

    @Test
    public void testNestedTransactionalWithBeginOrJoinFail() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("nestedTransactionalWithBeginOrJoinFail");
        MuleEvent event = JdbcTxTransactionalElementTestCase.getTestEvent((Object)"message", (FlowConstruct)flow);
        try {
            flow.process(event);
        }
        catch (Exception e) {
            // empty catch block
        }
        Integer countWithType1 = this.getCountWithType1();
        Integer countWithType2 = this.getCountWithType2();
        Assert.assertThat((Object)countWithType1, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)countWithType2, (Matcher)Is.is((Object)0));
    }

    @Test
    public void testNestedTransactionalWithBeginOrJoinFailWithCatch() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("nestedTransactionalWithBeginOrJoinFailWithCatch");
        MuleEvent event = JdbcTxTransactionalElementTestCase.getTestEvent((Object)"message", (FlowConstruct)flow);
        flow.process(event);
        Integer countWithType1 = this.getCountWithType1();
        Integer countWithType2 = this.getCountWithType2();
        Assert.assertThat((Object)countWithType1, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)countWithType2, (Matcher)Is.is((Object)1));
    }
}

