/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.functional;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transport.NullPayload;
import org.mule.transport.jdbc.functional.AbstractJdbcFunctionalTestCase;

public class JdbcMessagePropertiesCopyingTestCase
extends AbstractJdbcFunctionalTestCase {
    private static final String PROPERTY_KEY = "custom-key";
    private static final String PROPERTY_VALUE = "custom-value";

    public JdbcMessagePropertiesCopyingTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, AbstractJdbcFunctionalTestCase.getConfig() + ", jdbc-message-properties-copying-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, AbstractJdbcFunctionalTestCase.getConfig() + ", jdbc-message-properties-copying-flow.xml"});
    }

    @Test
    public void testMessagePropertiesCopying() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        message.setOutboundProperty("type", (Object)1);
        message.setOutboundProperty(PROPERTY_KEY, (Object)PROPERTY_VALUE);
        MuleMessage result = client.send("vm://in", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertNull((Object)result.getExceptionPayload());
        Assert.assertFalse((boolean)(result.getPayload() instanceof NullPayload));
        Assert.assertEquals((Object)PROPERTY_VALUE, (Object)result.getInboundProperty(PROPERTY_KEY));
    }
}

