/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.reliability;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ArrayHandler;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.probe.Probe;
import org.mule.transport.jdbc.reliability.InboundMessageLossTestCase;

public class InboundMessageLossTransactionsTestCase
extends InboundMessageLossTestCase {
    public InboundMessageLossTransactionsTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList(new Object[][]{{AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "reliability/jdbc-connector.xml, reliability/inbound-message-loss-transactions.xml"}});
    }

    @Override
    @Test
    public void testComponentException() throws Exception {
        Assert.assertEquals((long)1L, (long)this.qr.update(this.jdbcConnector.getConnection(), "INSERT INTO TEST(TYPE, DATA, ACK, RESULT) VALUES (4, 'Test Message', NULL, NULL)"));
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                try {
                    Object[] queryResult = (Object[])InboundMessageLossTransactionsTestCase.this.qr.query(InboundMessageLossTransactionsTestCase.this.jdbcConnector.getConnection(), "SELECT DATA FROM TEST WHERE TYPE = 4 AND ACK IS NULL", (ResultSetHandler)new ArrayHandler());
                    return queryResult != null && queryResult.length == 1;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public String describeFailure() {
                return "Row should not be acknowledged (marked read)";
            }
        });
    }
}

