/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.sqlstrategy;

import java.sql.Connection;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.transaction.Transaction;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transaction.TransactionCoordination;
import org.mule.transport.jdbc.JdbcConnector;
import org.mule.transport.jdbc.sqlstrategy.SqlStatementStrategy;
import org.mule.transport.jdbc.sqlstrategy.SqlStatementStrategyExecutor;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class SqlStatementStrategyExecutorTestCase
extends AbstractMuleTestCase {
    public static final int TIMEOUT = 1000;
    @Mock
    private SqlStatementStrategy mockStatementStrategy;
    @Mock
    private Connection mockConnection;
    @Mock
    private JdbcConnector mockConnector;
    @Mock
    private ImmutableEndpoint mockEndpoint;
    @Mock
    private MuleEvent mockEvent;
    @Mock
    private Transaction mockTransaction;

    @Before
    public void setUpTest() {
        TransactionCoordination.getInstance().clear();
    }

    @Test
    public void testExecute() throws Exception {
        SqlStatementStrategyExecutor sqlStatementStrategyExecutor = new SqlStatementStrategyExecutor();
        sqlStatementStrategyExecutor.execute(this.mockStatementStrategy, this.mockConnector, this.mockEndpoint, this.mockEvent, 1000L, this.mockConnection);
        ((SqlStatementStrategy)Mockito.verify((Object)this.mockStatementStrategy)).executeStatement(this.mockConnector, this.mockEndpoint, this.mockEvent, 1000L, this.mockConnection);
        ((Connection)Mockito.verify((Object)this.mockConnection)).commit();
        ((Connection)Mockito.verify((Object)this.mockConnection)).close();
    }

    @Test(expected=RuntimeException.class)
    public void testExecuteWithException() throws Exception {
        SqlStatementStrategyExecutor sqlStatementStrategyExecutor = new SqlStatementStrategyExecutor();
        Mockito.when((Object)this.mockStatementStrategy.executeStatement(this.mockConnector, this.mockEndpoint, this.mockEvent, 1000L, this.mockConnection)).thenThrow(new Throwable[]{new RuntimeException()});
        sqlStatementStrategyExecutor.execute(this.mockStatementStrategy, this.mockConnector, this.mockEndpoint, this.mockEvent, 1000L, this.mockConnection);
        ((SqlStatementStrategy)Mockito.verify((Object)this.mockStatementStrategy)).executeStatement(this.mockConnector, this.mockEndpoint, this.mockEvent, 1000L, this.mockConnection);
        ((Connection)Mockito.verify((Object)this.mockConnection)).rollback();
        ((Connection)Mockito.verify((Object)this.mockConnection)).close();
    }

    @Test
    public void testExecuteWithTx() throws Exception {
        TransactionCoordination.getInstance().bindTransaction(this.mockTransaction);
        SqlStatementStrategyExecutor sqlStatementStrategyExecutor = new SqlStatementStrategyExecutor();
        sqlStatementStrategyExecutor.execute(this.mockStatementStrategy, this.mockConnector, this.mockEndpoint, this.mockEvent, 1000L, this.mockConnection);
        ((SqlStatementStrategy)Mockito.verify((Object)this.mockStatementStrategy)).executeStatement(this.mockConnector, this.mockEndpoint, this.mockEvent, 1000L, this.mockConnection);
        ((Connection)Mockito.verify((Object)this.mockConnection, (VerificationMode)VerificationModeFactory.times((int)0))).commit();
        ((Connection)Mockito.verify((Object)this.mockConnection, (VerificationMode)VerificationModeFactory.times((int)0))).close();
    }

    @Test(expected=RuntimeException.class)
    public void testExecuteWithExceptionWithTx() throws Exception {
        TransactionCoordination.getInstance().bindTransaction(this.mockTransaction);
        SqlStatementStrategyExecutor sqlStatementStrategyExecutor = new SqlStatementStrategyExecutor();
        Mockito.when((Object)this.mockStatementStrategy.executeStatement(this.mockConnector, this.mockEndpoint, this.mockEvent, 1000L, this.mockConnection)).thenThrow(new Throwable[]{new RuntimeException()});
        sqlStatementStrategyExecutor.execute(this.mockStatementStrategy, this.mockConnector, this.mockEndpoint, this.mockEvent, 1000L, this.mockConnection);
        ((SqlStatementStrategy)Mockito.verify((Object)this.mockStatementStrategy)).executeStatement(this.mockConnector, this.mockEndpoint, this.mockEvent, 1000L, this.mockConnection);
        ((Connection)Mockito.verify((Object)this.mockConnection, (VerificationMode)VerificationModeFactory.times((int)0))).rollback();
        ((Connection)Mockito.verify((Object)this.mockConnection, (VerificationMode)VerificationModeFactory.times((int)0))).close();
    }
}

