/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc;

import java.util.HashMap;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.enhydra.jdbc.standard.StandardDataSource;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transport.Connector;
import org.mule.common.Result;
import org.mule.common.Testable;
import org.mule.tck.util.MuleDerbyTestUtils;
import org.mule.transport.AbstractConnectorTestCase;
import org.mule.transport.jdbc.JdbcConnector;
import org.mule.transport.jdbc.xa.DataSourceWrapper;

public class JdbcConnectorTestCase
extends AbstractConnectorTestCase {
    private static final String DATABASE_NAME = "embeddedDb";

    protected void doSetUp() throws Exception {
        MuleDerbyTestUtils.createDataBase((String)DATABASE_NAME);
        super.doSetUp();
    }

    protected void doTearDown() throws Exception {
        MuleDerbyTestUtils.cleanupDerbyDb((String)DATABASE_NAME);
        super.doTearDown();
    }

    public Connector createConnector() throws Exception {
        JdbcConnector c = new JdbcConnector(muleContext);
        EmbeddedDataSource embeddedDS = new EmbeddedDataSource();
        embeddedDS.setDatabaseName(DATABASE_NAME);
        c.setName("JdbcConnector");
        c.setDataSource((DataSource)embeddedDS);
        c.setPollingFrequency(1000L);
        return c;
    }

    public Object getValidMessage() throws Exception {
        HashMap map = new HashMap();
        return map;
    }

    public String getTestEndpointURI() {
        return "jdbc://test?sql=SELECT * FROM TABLE";
    }

    @Test
    public void testConnectionConnectorStartedSucess() throws MuleException {
        this.getConnector().start();
        Assert.assertTrue((boolean)this.getConnector().isStarted());
        Assert.assertTrue((boolean)this.getConnector().isConnected());
        Assert.assertTrue((boolean)(this.getConnector() instanceof Testable));
        Assert.assertTrue((((Testable)this.getConnector()).test().getStatus() == Result.Status.SUCCESS ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.getConnector().isStarted());
        Assert.assertTrue((boolean)this.getConnector().isConnected());
    }

    @Test
    public void testConnectionConnectorStoppedSucess() {
        Assert.assertFalse((boolean)this.getConnector().isStarted());
        Assert.assertFalse((boolean)this.getConnector().isConnected());
        Assert.assertTrue((boolean)(this.getConnector() instanceof Testable));
        Assert.assertTrue((((Testable)this.getConnector()).test().getStatus() == Result.Status.SUCCESS ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.getConnector().isStarted());
        Assert.assertFalse((boolean)this.getConnector().isConnected());
    }

    @Test
    public void testConnectionInvalidConfigParamFailure() throws MuleException {
        ((JdbcConnector)this.getConnector()).setDataSource(null);
        Assert.assertFalse((boolean)this.getConnector().isStarted());
        Assert.assertFalse((boolean)this.getConnector().isConnected());
        Assert.assertTrue((boolean)(this.getConnector() instanceof Testable));
        Assert.assertTrue((((Testable)this.getConnector()).test().getStatus() == Result.Status.FAILURE ? 1 : 0) != 0);
        System.out.println(((Testable)this.getConnector()).test().getMessage());
        Assert.assertFalse((boolean)this.getConnector().isStarted());
        Assert.assertFalse((boolean)this.getConnector().isConnected());
    }

    @Test
    public void testConnectionUnreachableFailure() throws MuleException {
        ((JdbcConnector)this.getConnector()).setDataSource((DataSource)new StandardDataSource());
        Assert.assertFalse((boolean)this.getConnector().isStarted());
        Assert.assertFalse((boolean)this.getConnector().isConnected());
        Assert.assertTrue((boolean)(this.getConnector() instanceof Testable));
        Assert.assertTrue((((Testable)this.getConnector()).test().getStatus() == Result.Status.FAILURE ? 1 : 0) != 0);
        System.out.println(((Testable)this.getConnector()).test().getMessage());
        Assert.assertFalse((boolean)this.getConnector().isStarted());
        Assert.assertFalse((boolean)this.getConnector().isConnected());
    }

    @Test
    public void dataSourceIsNotWrappedWhenNotUsingXA() throws InitialisationException {
        DataSource mockDataSource = (DataSource)Mockito.mock(DataSource.class);
        DataSource dataSource = this.getDataSourceAfterInitialization(mockDataSource);
        Assert.assertThat((Object)dataSource, (Matcher)Is.is((Object)mockDataSource));
    }

    @Test
    public void dataSourceIsWrappedWhenUsingXA() throws InitialisationException {
        DataSource mockDataSource = (DataSource)Mockito.mock(TestXADataSource.class);
        DataSource dataSource = this.getDataSourceAfterInitialization(mockDataSource);
        Assert.assertThat((Object)dataSource, (Matcher)IsInstanceOf.instanceOf(DataSourceWrapper.class));
    }

    private DataSource getDataSourceAfterInitialization(DataSource mockDataSource) throws InitialisationException {
        JdbcConnector connector = new JdbcConnector(muleContext);
        connector.setDataSource(mockDataSource);
        connector.setName("testConnector");
        connector.initialise();
        return connector.getDataSource();
    }

    private static interface TestXADataSource
    extends XADataSource,
    DataSource {
    }
}

