/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.functional;

import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transport.jdbc.functional.AbstractJdbcFunctionalTestCase;

public class JdbcEndpointWithNestedQueriesTestCase
extends AbstractJdbcFunctionalTestCase {
    public JdbcEndpointWithNestedQueriesTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
        this.setPopulateTestData(false);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList(new Object[][]{{AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "jdbc-endpoint-with-nested-queries-test.xml"}});
    }

    @Test
    public void testDisposeAfterQueryExecution() throws Exception {
        QueryRunner queryRunner = this.jdbcConnector.getQueryRunner();
        Connection connection = this.jdbcConnector.getConnection();
        LocalMuleClient client = muleContext.getClient();
        client.send("vm://in", (Object)"some test data", null);
        List results = (List)queryRunner.query(connection, "SELECT * FROM TEST", (ResultSetHandler)new ArrayListHandler());
        Assert.assertEquals((long)1L, (long)results.size());
        try {
            muleContext.dispose();
        }
        catch (Exception ex) {
            Assert.fail((String)"Server disposal failed");
        }
    }
}

