/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.functional;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transport.NullPayload;
import org.mule.transport.jdbc.functional.AbstractJdbcFunctionalTestCase;

public class JdbcNullParamsTestCase
extends AbstractJdbcFunctionalTestCase {
    public JdbcNullParamsTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
        this.setPopulateTestData(false);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList(new Object[][]{{AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "jdbc-null-params.xml"}});
    }

    @Test
    public void testJdbcNullParams() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage reply = client.request("jdbc://getTest", 1000L);
        Assert.assertTrue((boolean)(reply.getPayload() instanceof Collection));
        Assert.assertTrue((boolean)((Collection)reply.getPayload()).isEmpty());
        client.send("jdbc://writeTest", (MuleMessage)new DefaultMuleMessage((Object)NullPayload.getInstance(), muleContext));
        reply = client.request("jdbc://getTest", 1000L);
        Assert.assertNotNull((Object)reply);
        Assert.assertTrue((boolean)(reply.getPayload() instanceof Collection));
        Collection result = (Collection)reply.getPayload();
        Assert.assertEquals((long)1L, (long)result.size());
        Map res = (Map)result.iterator().next();
        Integer id = (Integer)res.get("ID");
        Assert.assertEquals((long)1L, (long)id.intValue());
        Assert.assertNull(res.get("TYPE"));
        Assert.assertNull(res.get("DATA"));
        Assert.assertNull(res.get("RESULT"));
    }
}

