/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.functional;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.dbutils.QueryRunner;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEventContext;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.listener.ConnectionListener;
import org.mule.tck.util.MuleDerbyTestUtils;
import org.mule.transport.jdbc.JdbcConnector;

@RunWith(value=Parameterized.class)
public class JdbcReconnectionTestCase
extends FunctionalTestCase {
    private String configFile;

    public JdbcReconnectionTestCase(String configFile) {
        this.setStartContext(false);
        this.configFile = configFile;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"jdbc-reconnection-blocking-config.xml"}, {"jdbc-reconnection-nonblocking-config.xml"});
    }

    protected String getConfigFile() {
        return this.configFile;
    }

    @AfterClass
    public static void stopDatabase() throws SQLException {
        MuleDerbyTestUtils.stopDatabase();
    }

    @Test
    public void reconnectsAfterConnectException() throws Exception {
        final CountDownLatch messageReceivedLatch = new CountDownLatch(1);
        CountDownLatch connectFailedLatch = new CountDownLatch(3);
        final CountDownLatch reconnectedLatch = new CountDownLatch(1);
        this.getFunctionalTestComponent("test").setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                messageReceivedLatch.countDown();
            }
        });
        ConnectionListener connectionListener = new ConnectionListener(muleContext).setExpectedAction(702).setNumberOfExecutionsRequired(3);
        MuleDerbyTestUtils.defaultDerbyCleanAndInit((String)"derby.properties", (String)"database.name");
        this.initializeDatabase();
        muleContext.start();
        Assert.assertTrue((String)"No message received", (boolean)messageReceivedLatch.await(30000L, TimeUnit.MILLISECONDS));
        JdbcReconnectionTestCase.stopDatabase();
        connectionListener.waitUntilNotificationsAreReceived();
        this.getFunctionalTestComponent("test").setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                reconnectedLatch.countDown();
            }
        });
        MuleDerbyTestUtils.defaultDerbyCleanAndInit((String)"derby.properties", (String)"database.name");
        this.initializeDatabase();
        Assert.assertTrue((String)"Reconnection failed", (boolean)reconnectedLatch.await(30000L, TimeUnit.MILLISECONDS));
        JdbcReconnectionTestCase.stopDatabase();
    }

    private void initializeDatabase() throws Exception {
        JdbcConnector jdbcConnector = (JdbcConnector)muleContext.getRegistry().lookupConnector("jdbcConnector");
        QueryRunner qr = jdbcConnector.getQueryRunner();
        qr.update(jdbcConnector.getConnection(), "CREATE TABLE TEST(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY, DATA VARCHAR(255))");
        qr.update(jdbcConnector.getConnection(), "INSERT INTO TEST(DATA) VALUES ('a')");
    }
}

