/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.functional;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.listener.ConnectionListener;
import org.mule.transport.jdbc.functional.AbstractJdbcFunctionalTestCase;

@RunWith(value=Parameterized.class)
public class JdbcReconnectionTestCase
extends AbstractJdbcFunctionalTestCase {
    public JdbcReconnectionTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "jdbc-reconnection-blocking-config.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "jdbc-reconnection-nonblocking-config.xml"});
    }

    @Test
    public void reconnectsAfterConnectException() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.request("vm://out", 5000L);
        Assert.assertNotNull((String)"No message received", (Object)message);
        ConnectionListener connectionListener = new ConnectionListener(muleContext).setExpectedAction(702).setNumberOfExecutionsRequired(3);
        JdbcReconnectionTestCase.stopDatabase();
        connectionListener.waitUntilNotificationsAreReceived();
        JdbcReconnectionTestCase.startDatabase();
        this.createTable();
        this.populateTable();
        message = client.request("vm://out", 5000L);
        Assert.assertNotNull((String)"Reconnection failed", (Object)message);
    }
}

