/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.functional;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.apache.commons.dbcp.BasicDataSource;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.construct.Flow;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.util.MuleDerbyTestDatabase;
import org.mule.util.concurrent.Latch;

public class JdbcTxOutboundEndpointsTestCase
extends FunctionalTestCase {
    private static MuleDerbyTestDatabase derbyTestDatabase = new MuleDerbyTestDatabase("database.name");

    protected String getConfigFile() {
        return "jdbc-tx-outbound-endpoints-config.xml";
    }

    @BeforeClass
    public static void startDatabase() throws Exception {
        derbyTestDatabase.startDatabase();
    }

    @AfterClass
    public static void stopDatabase() throws SQLException {
        derbyTestDatabase.stopDatabase();
    }

    @Test
    public void concurrentRequestsDoNotGenerateDeadlock() throws Exception {
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        this.processEvent(executorService, true);
        Latch firstQueryExecutedLatch = (Latch)muleContext.getRegistry().lookupObject("firstQueryExecutedLatch");
        firstQueryExecutedLatch.await();
        this.processEvent(executorService, false);
        CountDownLatch finishedLatch = (CountDownLatch)muleContext.getRegistry().lookupObject("finishedLatch");
        Assert.assertThat((Object)finishedLatch.await(5000L, TimeUnit.MILLISECONDS), (Matcher)Is.is((Object)true));
    }

    private void processEvent(ExecutorService executorService, final boolean executeFirstQuery) {
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Flow flow = (Flow)JdbcTxOutboundEndpointsTestCase.this.getFlowConstruct("test");
                    MuleEvent event = AbstractMuleContextTestCase.getTestEvent((Object)"Test Message");
                    event.setFlowVariable("executeFirstQuery", (Object)executeFirstQuery);
                    flow.process(event);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static class LatchReleasingDataSource
    extends BasicDataSource {
        private AtomicInteger connectionRequestsCount = new AtomicInteger(0);
        private int connectionRequestsUntilRelease;
        private Latch latch;

        public Connection getConnection() throws SQLException {
            if (this.connectionRequestsCount.incrementAndGet() == this.connectionRequestsUntilRelease) {
                this.latch.release();
            }
            return super.getConnection();
        }

        public void setLatch(Latch latch) {
            this.latch = latch;
        }

        public void setConnectionRequestsUntilRelease(int connectionRequestsUntilRelease) {
            this.connectionRequestsUntilRelease = connectionRequestsUntilRelease;
        }

        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new SQLFeatureNotSupportedException();
        }
    }
}

