/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.hamcrest.CoreMatchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleContext;
import org.mule.api.transaction.TransactionException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transport.jdbc.JdbcTransaction;

@SmallTest
public class JdbcTransactionTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private SQLException expectedExceptionCause;
    private JdbcTransaction tx;
    private Connection connection;
    private MuleContext muleContext;

    @Before
    public void initializeMocks() throws SQLException, TransactionException {
        this.muleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.muleContext.getConfiguration().getId()).thenReturn((Object)"myApp");
        this.tx = new JdbcTransaction(this.muleContext);
        this.connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)this.connection.getAutoCommit()).thenReturn((Object)false);
        this.tx.bindResource(Mockito.mock(DataSource.class), (Object)this.connection);
    }

    @After
    public void ensureConnectionCloseWasCalled() throws SQLException {
        ((Connection)Mockito.verify((Object)this.connection)).close();
    }

    @Test
    public void closeConnectionIfErrorOnCommit() throws Exception {
        this.addExceptionExpectation();
        ((Connection)Mockito.doThrow((Throwable)this.expectedExceptionCause).when((Object)this.connection)).commit();
        this.tx.commit();
    }

    @Test
    public void closeConnectionIfErrorOnRollback() throws Exception {
        this.addExceptionExpectation();
        ((Connection)Mockito.doThrow((Throwable)this.expectedExceptionCause).when((Object)this.connection)).rollback();
        this.tx.rollback();
    }

    @Test
    public void closeConnectionIfCommitOk() throws Exception {
        this.tx.commit();
    }

    @Test
    public void closeConnectionIfRollbackOk() throws Exception {
        this.tx.rollback();
    }

    @Test
    public void raiseCloseExceptionAfterCommitOk() throws Exception {
        this.addExceptionExpectation();
        ((Connection)Mockito.doThrow((Throwable)this.expectedExceptionCause).when((Object)this.connection)).close();
        this.tx.commit();
    }

    @Test
    public void raiseCloseExceptionAfterRollbackOk() throws Exception {
        this.addExceptionExpectation();
        ((Connection)Mockito.doThrow((Throwable)this.expectedExceptionCause).when((Object)this.connection)).close();
        this.tx.rollback();
    }

    @Test
    public void raiseCommitExceptionIfCommitAndCloseFail() throws Exception {
        this.addExceptionExpectation();
        ((Connection)Mockito.doThrow((Throwable)this.expectedExceptionCause).when((Object)this.connection)).commit();
        ((Connection)Mockito.doThrow((Throwable)new SQLException()).when((Object)this.connection)).close();
        this.tx.commit();
    }

    @Test
    public void raiseRollbackExceptionIfRollbackAndCloseFail() throws Exception {
        this.addExceptionExpectation();
        ((Connection)Mockito.doThrow((Throwable)this.expectedExceptionCause).when((Object)this.connection)).rollback();
        ((Connection)Mockito.doThrow((Throwable)new SQLException()).when((Object)this.connection)).close();
        this.tx.rollback();
    }

    private void addExceptionExpectation() {
        this.expectedExceptionCause = new SQLException();
        this.expectedException.expect(TransactionException.class);
        this.expectedException.expectCause(CoreMatchers.is((Object)this.expectedExceptionCause));
    }
}

