/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.api.DefaultMuleException;
import org.mule.api.config.ExceptionReader;
import org.mule.config.ExceptionHelper;
import org.mule.config.i18n.MessageFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.transport.jdbc.SQLExceptionReader;

public class SqlExceptionReaderTestCase
extends AbstractMuleTestCase {
    @Before
    public void registerExceptionReader() {
        ExceptionHelper.registerExceptionReader((ExceptionReader)new SQLExceptionReader());
    }

    @Test
    public void testNestedExceptionRetreval() throws Exception {
        Exception testException = this.getException();
        Throwable t = ExceptionHelper.getRootException((Throwable)testException);
        Assert.assertNotNull((Object)t);
        Assert.assertEquals((Object)"blah", (Object)t.getMessage());
        Assert.assertNull((Object)t.getCause());
        t = ExceptionHelper.getRootMuleException((Throwable)testException);
        Assert.assertNotNull((Object)t);
        Assert.assertEquals((Object)"bar", (Object)t.getMessage());
        Assert.assertNotNull((Object)t.getCause());
        List l = ExceptionHelper.getExceptionsAsList((Throwable)testException);
        Assert.assertEquals((long)4L, (long)l.size());
        Map info = ExceptionHelper.getExceptionInfo((Throwable)testException);
        Assert.assertNotNull((Object)info);
        Assert.assertEquals((long)2L, (long)info.size());
        Assert.assertEquals((Object)"1234", info.get("SQL Code"));
        Assert.assertEquals((Object)"bad SQL state", info.get("SQL State"));
    }

    private Exception getException() {
        SQLException e = new SQLException("SQL error", "bad SQL state", 1234);
        e.setNextException(new SQLException("blah"));
        return new DefaultMuleException(MessageFactory.createStaticMessage((String)"foo"), (Throwable)new DefaultMuleException(MessageFactory.createStaticMessage((String)"bar"), (Throwable)e));
    }
}

