/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.config;

import org.enhydra.jdbc.standard.StandardDataSource;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;

public class JdbcDataSourceNamespaceHandlerTestCase
extends FunctionalTestCase {
    public JdbcDataSourceNamespaceHandlerTestCase() {
        this.setStartContext(false);
    }

    protected String getConfigFile() {
        return "jdbc-data-source-namespace-config.xml";
    }

    @Test
    public void testSingleton() {
        StandardDataSource ds1 = this.lookupDataSource("default-oracle");
        StandardDataSource ds2 = this.lookupDataSource("default-oracle");
        Assert.assertSame((Object)ds1, (Object)ds2);
    }

    @Test
    public void testCustomDataSourceProperties() {
        StandardDataSource source = this.lookupDataSource("custom-ds-properties");
        Assert.assertEquals((long)8L, (long)source.getTransactionIsolation());
        Assert.assertEquals((long)42L, (long)source.getLoginTimeout());
    }

    @Test
    public void testOracleDefaults() {
        StandardDataSource source = this.lookupDataSource("default-oracle");
        Assert.assertEquals((Object)"jdbc:oracle:thin:@localhost:1521:orcl", (Object)source.getUrl());
        Assert.assertEquals((Object)"oracle.jdbc.driver.OracleDriver", (Object)source.getDriverName());
        Assert.assertEquals((long)-1L, (long)source.getTransactionIsolation());
        Assert.assertEquals((Object)"scott", (Object)source.getUser());
        Assert.assertEquals((Object)"tiger", (Object)source.getPassword());
    }

    @Test
    public void testOracleCustomUrl() {
        StandardDataSource source = this.lookupDataSource("custom-url-oracle");
        Assert.assertEquals((Object)"jdbc:oracle:thin:@some-other-host:1522:mule", (Object)source.getUrl());
    }

    @Test
    public void testOracleCustomHost() {
        StandardDataSource source = this.lookupDataSource("custom-host-oracle");
        Assert.assertEquals((Object)"jdbc:oracle:thin:@some-other-host:1521:orcl", (Object)source.getUrl());
    }

    @Test
    public void testOracleCustomPort() {
        StandardDataSource source = this.lookupDataSource("custom-port-oracle");
        Assert.assertEquals((Object)"jdbc:oracle:thin:@localhost:1522:orcl", (Object)source.getUrl());
    }

    @Test
    public void testOracleCustomInstance() {
        StandardDataSource source = this.lookupDataSource("custom-instance-oracle");
        Assert.assertEquals((Object)"jdbc:oracle:thin:@localhost:1521:mule", (Object)source.getUrl());
    }

    @Test
    public void testMysqlDefaults() {
        StandardDataSource source = this.lookupDataSource("default-mysql");
        Assert.assertEquals((Object)"jdbc:mysql://localhost/mule", (Object)source.getUrl());
        Assert.assertEquals((Object)"com.mysql.jdbc.Driver", (Object)source.getDriverName());
        Assert.assertEquals((Object)"mysql", (Object)source.getUser());
        Assert.assertEquals((Object)"secret", (Object)source.getPassword());
    }

    @Test
    public void testMysqlCustomUrl() {
        StandardDataSource source = this.lookupDataSource("custom-url-mysql");
        Assert.assertEquals((Object)"jdbc:mysql://mule-db-host:3306/mule", (Object)source.getUrl());
    }

    @Test
    public void testMysqlCustomHost() {
        StandardDataSource source = this.lookupDataSource("custom-host-mysql");
        Assert.assertEquals((Object)"jdbc:mysql://some-other-host/mule", (Object)source.getUrl());
    }

    @Test
    public void testMysqlCustomPort() {
        StandardDataSource source = this.lookupDataSource("custom-port-mysql");
        Assert.assertEquals((Object)"jdbc:mysql://localhost:4242/mule", (Object)source.getUrl());
    }

    @Test
    public void testPostgresqlDefaults() {
        StandardDataSource source = this.lookupDataSource("default-postgresql");
        Assert.assertEquals((Object)"jdbc:postgresql://localhost/mule", (Object)source.getUrl());
        Assert.assertEquals((Object)"org.postgresql.Driver", (Object)source.getDriverName());
        Assert.assertEquals((Object)"postgres", (Object)source.getUser());
        Assert.assertEquals((Object)"secret", (Object)source.getPassword());
    }

    @Test
    public void testPostgresqlCustomUrl() {
        StandardDataSource source = this.lookupDataSource("custom-url-postgresql");
        Assert.assertEquals((Object)"jdbc:postgresql://mule-db-host:5432/mule", (Object)source.getUrl());
    }

    @Test
    public void testPostgresqlCustomHost() {
        StandardDataSource source = this.lookupDataSource("custom-host-postgresql");
        Assert.assertEquals((Object)"jdbc:postgresql://some-other-host/mule", (Object)source.getUrl());
    }

    @Test
    public void testPostgresqlCustomPort() {
        StandardDataSource source = this.lookupDataSource("custom-port-postgresql");
        Assert.assertEquals((Object)"jdbc:postgresql://localhost:5433/mule", (Object)source.getUrl());
    }

    @Test
    public void testDerbyDefaults() {
        StandardDataSource source = this.lookupDataSource("default-derby");
        Assert.assertEquals((Object)"jdbc:derby:memory:mule", (Object)source.getUrl());
        Assert.assertEquals((Object)"org.apache.derby.jdbc.EmbeddedDriver", (Object)source.getDriverName());
    }

    @Test
    public void testDerbyCustomUrl() {
        StandardDataSource source = this.lookupDataSource("custom-url-derby");
        Assert.assertEquals((Object)"jdbc:derby:muleEmbedded", (Object)source.getUrl());
    }

    @Test
    public void testDerbyCreateDatabase() {
        StandardDataSource source = this.lookupDataSource("create-database-derby");
        Assert.assertEquals((Object)"jdbc:derby:memory:mule;create=true", (Object)source.getUrl());
    }

    private StandardDataSource lookupDataSource(String key) {
        Object object = muleContext.getRegistry().lookupObject(key);
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof StandardDataSource));
        return (StandardDataSource)object;
    }
}

