/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.functional;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transport.jdbc.functional.AbstractJdbcFunctionalTestCase;

public class JdbcSelectOnOutboundFunctionalTestCase
extends AbstractJdbcFunctionalTestCase {
    public JdbcSelectOnOutboundFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, AbstractJdbcFunctionalTestCase.getConfig() + ",jdbc-select-outbound-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, AbstractJdbcFunctionalTestCase.getConfig() + ",jdbc-select-outbound-flow.xml"});
    }

    @Test
    public void testSelectOnOutbound() throws Exception {
        this.doSelectOnOutbound("vm://jdbc.test");
    }

    @Test
    public void testSelectOnOutboundByExpression() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MyMessage payload = new MyMessage(2);
        MuleMessage reply = client.send("vm://terra", (MuleMessage)new DefaultMuleMessage((Object)payload, muleContext));
        Assert.assertNotNull((Object)reply.getPayload());
        Assert.assertTrue((boolean)(reply.getPayload() instanceof List));
        List resultList = (List)reply.getPayload();
        Assert.assertTrue((resultList.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(resultList.get(0) instanceof Map));
        Map resultMap = (Map)resultList.get(0);
        Assert.assertEquals((Object)new Integer(2), resultMap.get("TYPE"));
        Assert.assertEquals((Object)TEST_VALUES[1], resultMap.get("DATA"));
    }

    @Test
    public void testChain2SelectAlwaysBegin() throws Exception {
        this.doSelectOnOutbound("vm://chain.always.begin");
    }

    @Test
    public void testChain2SelectBeginOrJoin() throws Exception {
        this.doSelectOnOutbound("vm://chain.begin.or.join");
    }

    private void doSelectOnOutbound(String endpoint) throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage reply = client.send(endpoint, new Object(), null);
        Assert.assertNotNull((Object)reply.getPayload());
        Assert.assertTrue((boolean)(reply.getPayload() instanceof List));
        List resultList = (List)reply.getPayload();
        Assert.assertTrue((resultList.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(resultList.get(0) instanceof Map));
        Map resultMap = (Map)resultList.get(0);
        Assert.assertEquals((Object)new Integer(1), resultMap.get("TYPE"));
        Assert.assertEquals((Object)TEST_VALUES[0], resultMap.get("DATA"));
    }

    public static class MyMessage
    implements Serializable {
        private int type;

        public MyMessage(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }
    }
}

