/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.functional;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ArrayHandler;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transport.jdbc.functional.AbstractJdbcFunctionalTestCase;

public class JdbcFunctionalTestCase
extends AbstractJdbcFunctionalTestCase {
    public JdbcFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
        this.setPopulateTestData(false);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, AbstractJdbcFunctionalTestCase.getConfig() + ",jdbc-functional-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, AbstractJdbcFunctionalTestCase.getConfig() + ",jdbc-functional-config-flow.xml"});
    }

    @Test
    public void testDirectSql() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.request("jdbc://SELECT * FROM TEST", 1000L);
        JdbcFunctionalTestCase.assertResultSetEmpty(message);
        QueryRunner qr = this.jdbcConnector.getQueryRunner();
        int updated = qr.update(this.jdbcConnector.getConnection(), "INSERT INTO TEST(TYPE, DATA) VALUES (1, 'Test Message')");
        Assert.assertEquals((long)1L, (long)updated);
        message = client.request("jdbc://SELECT * FROM TEST", 1000L);
        JdbcFunctionalTestCase.assertResultSetNotEmpty(message);
    }

    @Test
    public void testSend() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.send("jdbc://writeTest?type=2", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        QueryRunner qr = this.jdbcConnector.getQueryRunner();
        Object[] obj2 = (Object[])qr.query(this.jdbcConnector.getConnection(), "SELECT DATA FROM TEST WHERE TYPE = 2", (ResultSetHandler)new ArrayHandler());
        Assert.assertNotNull((Object)obj2);
        Assert.assertEquals((long)1L, (long)obj2.length);
        Assert.assertEquals((Object)"Test Message", (Object)obj2[0]);
    }

    @Test
    public void testSendMap() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("data", "Test Message");
        client.send("jdbc://writeMap?type=2", (MuleMessage)new DefaultMuleMessage(map, muleContext));
        QueryRunner qr = this.jdbcConnector.getQueryRunner();
        Object[] obj2 = (Object[])qr.query(this.jdbcConnector.getConnection(), "SELECT DATA FROM TEST WHERE TYPE = 2", (ResultSetHandler)new ArrayHandler());
        Assert.assertNotNull((Object)obj2);
        Assert.assertEquals((long)1L, (long)obj2.length);
        Assert.assertEquals((Object)"Test Message", (Object)obj2[0]);
    }

    @Test
    public void testReceive() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.request("jdbc://getTest?type=1", 1000L);
        JdbcFunctionalTestCase.assertResultSetEmpty(message);
        QueryRunner qr = this.jdbcConnector.getQueryRunner();
        int updated = qr.update(this.jdbcConnector.getConnection(), "INSERT INTO TEST(TYPE, DATA, ACK, RESULT) VALUES (1, 'Test Message', NULL, NULL)");
        Assert.assertEquals((long)1L, (long)updated);
        message = client.request("jdbc://getTest?type=1", 1000L);
        JdbcFunctionalTestCase.assertResultSetNotEmpty(message);
    }

    @Test
    public void testReceiveAndSend() throws Exception {
        QueryRunner qr = this.jdbcConnector.getQueryRunner();
        qr.update(this.jdbcConnector.getConnection(), "INSERT INTO TEST(TYPE, DATA, ACK, RESULT) VALUES (1, 'Test Message', NULL, NULL)");
        long t0 = System.currentTimeMillis();
        while (System.currentTimeMillis() - t0 < 20000L) {
            Object[] rs = (Object[])qr.query(this.jdbcConnector.getConnection(), "SELECT COUNT(*) FROM TEST WHERE TYPE = 2", (ResultSetHandler)new ArrayHandler());
            Assert.assertNotNull((Object)rs);
            Assert.assertEquals((long)1L, (long)rs.length);
            if (((Number)rs[0]).intValue() > 0) break;
            Thread.sleep(100L);
        }
        Object[] obj2 = (Object[])qr.query(this.jdbcConnector.getConnection(), "SELECT DATA FROM TEST WHERE TYPE = 2", (ResultSetHandler)new ArrayHandler());
        Assert.assertNotNull((Object)obj2);
        Assert.assertEquals((long)1L, (long)obj2.length);
        Assert.assertEquals((Object)"Test Message Received", (Object)obj2[0]);
    }
}

