/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.config;

import org.apache.commons.dbutils.QueryRunner;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transaction.XaTransactionFactory;
import org.mule.transport.jdbc.ExtendedQueryRunner;
import org.mule.transport.jdbc.JdbcConnector;
import org.mule.transport.jdbc.JdbcTransactionFactory;
import org.mule.transport.jdbc.sqlstrategy.DefaultSqlStatementStrategyFactory;
import org.mule.transport.jdbc.test.TestDataSource;

public class JdbcNamespaceHandlerTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "jdbc-namespace-config.xml";
    }

    @Test
    public void testWithDataSource() throws Exception {
        JdbcConnector c = (JdbcConnector)muleContext.getRegistry().lookupConnector("jdbcConnector1");
        Assert.assertNotNull((Object)c);
        Assert.assertTrue((boolean)(c.getDataSource() instanceof TestDataSource));
        Assert.assertNull((Object)c.getQueries());
        Assert.assertEquals((long)-1L, (long)c.getQueryTimeout());
    }

    @Test
    public void testWithDataSourceViaJndi() throws Exception {
        JdbcConnector c = (JdbcConnector)muleContext.getRegistry().lookupConnector("jdbcConnector2");
        Assert.assertNotNull((Object)c);
        Assert.assertTrue((boolean)(c.getDataSource() instanceof TestDataSource));
        Assert.assertNull((Object)c.getQueries());
        Assert.assertTrue((boolean)c.isConnected());
        Assert.assertTrue((boolean)c.isStarted());
        Assert.assertEquals((long)3L, (long)c.getQueryTimeout());
    }

    @Test
    public void testFullyConfigured() throws Exception {
        JdbcConnector c = (JdbcConnector)muleContext.getRegistry().lookupConnector("jdbcConnector3");
        Assert.assertNotNull((Object)c);
        Assert.assertTrue((boolean)(c.getDataSource() instanceof TestDataSource));
        Assert.assertNotNull((Object)c.getQueries());
        Assert.assertEquals((long)3L, (long)c.getQueries().size());
        Assert.assertTrue((boolean)c.isConnected());
        Assert.assertTrue((boolean)c.isStarted());
        Assert.assertTrue((boolean)c.isValidateConnections());
    }

    @Test
    public void testEndpointQueryOverride() throws Exception {
        JdbcConnector c = (JdbcConnector)muleContext.getRegistry().lookupConnector("jdbcConnector3");
        InboundEndpoint testJdbcEndpoint = muleContext.getEndpointFactory().getInboundEndpoint("testJdbcEndpoint");
        Assert.assertNotNull((Object)c.getQuery((ImmutableEndpoint)testJdbcEndpoint, "getTest"));
        Assert.assertNotNull((Object)c.getQuery((ImmutableEndpoint)testJdbcEndpoint, "getTest2"));
        Assert.assertEquals((Object)"OVERRIDDEN VALUE", (Object)c.getQuery((ImmutableEndpoint)testJdbcEndpoint, "getTest2"));
        Assert.assertNotNull((Object)c.getQuery((ImmutableEndpoint)testJdbcEndpoint, "getTest3"));
        Assert.assertNull((Object)c.getQuery((ImmutableEndpoint)testJdbcEndpoint, "getTest4"));
        Assert.assertEquals((Object)"3", (Object)testJdbcEndpoint.getProperty((Object)"queryTimeout"));
        QueryRunner queryRunner = c.getQueryRunnerFor((ImmutableEndpoint)testJdbcEndpoint);
        Assert.assertEquals(ExtendedQueryRunner.class, queryRunner.getClass());
        Assert.assertEquals((long)3L, (long)((ExtendedQueryRunner)queryRunner).getQueryTimeout());
    }

    @Test
    public void testEndpointWithTransaction() throws Exception {
        InboundEndpoint endpoint = muleContext.getRegistry().lookupEndpointBuilder("endpointWithTransaction").buildInboundEndpoint();
        Assert.assertNotNull((Object)endpoint);
        Assert.assertEquals(JdbcTransactionFactory.class, endpoint.getTransactionConfig().getFactory().getClass());
        Assert.assertEquals((long)0L, (long)endpoint.getTransactionConfig().getAction());
        Assert.assertEquals((Object)"-1", (Object)endpoint.getProperty((Object)"queryTimeout"));
    }

    @Test
    public void testEndpointWithXaTransaction() throws Exception {
        InboundEndpoint endpoint = muleContext.getRegistry().lookupEndpointBuilder("endpointWithXaTransaction").buildInboundEndpoint();
        Assert.assertNotNull((Object)endpoint);
        Assert.assertEquals(XaTransactionFactory.class, endpoint.getTransactionConfig().getFactory().getClass());
        Assert.assertEquals((long)1L, (long)endpoint.getTransactionConfig().getAction());
    }

    @Test
    public void testSqlStatementStrategyFactoryOverride() throws Exception {
        JdbcConnector c = (JdbcConnector)muleContext.getRegistry().lookupConnector("jdbcConnector4");
        Assert.assertNotNull((Object)c.getSqlStatementStrategyFactory());
        Assert.assertTrue((boolean)(c.getSqlStatementStrategyFactory() instanceof TestSqlStatementStrategyFactory));
        c = (JdbcConnector)muleContext.getRegistry().lookupConnector("jdbcConnector5");
        Assert.assertNotNull((Object)c.getSqlStatementStrategyFactory());
        Assert.assertTrue((boolean)(c.getSqlStatementStrategyFactory() instanceof TestSqlStatementStrategyFactory));
    }

    public static class TestSqlStatementStrategyFactory
    extends DefaultSqlStatementStrategyFactory {
    }
}

