/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.functional;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.mule.api.MuleMessage;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.util.MuleDerbyTestUtils;
import org.mule.transport.jdbc.JdbcConnector;
import org.mule.transport.jdbc.JdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbcFunctionalTestCase
extends AbstractServiceAndFlowTestCase {
    protected static final String[] TEST_VALUES = new String[]{"Test", "The Moon", "Terra"};
    protected JdbcConnector jdbcConnector;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJdbcFunctionalTestCase.class);
    private boolean populateTestData = true;

    protected static String getConfig() {
        return "jdbc-connector.xml";
    }

    public AbstractJdbcFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.jdbcConnector = (JdbcConnector)muleContext.getRegistry().lookupConnector("jdbcConnector");
        try {
            this.deleteTable();
        }
        catch (Exception e) {
            this.createTable();
        }
        if (this.populateTestData) {
            this.populateTable();
        }
    }

    protected void doTearDown() throws Exception {
        if (this.jdbcConnector != null) {
            this.deleteTable();
        }
        super.doTearDown();
    }

    protected void createTable() throws Exception {
        QueryRunner qr = this.jdbcConnector.getQueryRunner();
        qr.update(this.jdbcConnector.getConnection(), "CREATE TABLE TEST(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0)  NOT NULL PRIMARY KEY,TYPE INTEGER,DATA VARCHAR(255),ACK TIMESTAMP,RESULT VARCHAR(255))");
        LOGGER.debug("Table created");
    }

    protected void deleteTable() throws Exception {
        QueryRunner qr = this.jdbcConnector.getQueryRunner();
        int updated = qr.update(this.jdbcConnector.getConnection(), "DELETE FROM TEST");
        LOGGER.debug(updated + " rows deleted");
    }

    protected void populateTable() throws Exception {
        QueryRunner qr = this.jdbcConnector.getQueryRunner();
        int updated = qr.update(this.jdbcConnector.getConnection(), "INSERT INTO TEST(TYPE, DATA) VALUES (1, '" + TEST_VALUES[0] + "')");
        LOGGER.debug(updated + " rows updated");
        updated = qr.update(this.jdbcConnector.getConnection(), "INSERT INTO TEST(TYPE, DATA) VALUES (2, '" + TEST_VALUES[1] + "')");
        LOGGER.debug(updated + " rows updated");
        updated = qr.update(this.jdbcConnector.getConnection(), "INSERT INTO TEST(TYPE, DATA) VALUES (3, '" + TEST_VALUES[2] + "')");
        LOGGER.debug(updated + " rows updated");
    }

    @BeforeClass
    public static void startDatabase() throws Exception {
        MuleDerbyTestUtils.defaultDerbyCleanAndInit((String)"derby.properties", (String)"database.name");
    }

    @AfterClass
    public static void stopDatabase() throws SQLException {
        MuleDerbyTestUtils.stopDatabase();
    }

    protected static void assertResultSetEmpty(MuleMessage message) {
        Assert.assertNotNull((Object)message);
        Object payload = message.getPayload();
        junit.framework.Assert.assertTrue((boolean)(payload instanceof List));
        List list = (List)payload;
        junit.framework.Assert.assertTrue((boolean)list.isEmpty());
    }

    protected static void assertResultSetNotEmpty(MuleMessage message) {
        Assert.assertNotNull((Object)message);
        Object payload = message.getPayload();
        junit.framework.Assert.assertTrue((boolean)(payload instanceof List));
        List list = (List)payload;
        Assert.assertFalse((boolean)list.isEmpty());
    }

    public boolean isPopulateTestData() {
        return this.populateTestData;
    }

    public void setPopulateTestData(boolean populateTestData) {
        this.populateTestData = populateTestData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List execSqlQuery(String sql) throws Exception {
        Connection con = null;
        try {
            con = this.jdbcConnector.getConnection();
            List list = (List)new QueryRunner().query(con, sql, (ResultSetHandler)new ArrayListHandler());
            return list;
        }
        finally {
            JdbcUtils.close((Connection)con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int execSqlUpdate(String sql) throws Exception {
        Connection con = null;
        try {
            con = this.jdbcConnector.getConnection();
            int n = new QueryRunner().update(con, sql);
            return n;
        }
        finally {
            JdbcUtils.close((Connection)con);
        }
    }

    protected Integer getCountWithType1() throws Exception {
        return (Integer)((Object[])this.execSqlQuery("select count(*) from TEST where TYPE = 1").get(0))[0];
    }

    protected Integer getCountWithType2() throws Exception {
        return (Integer)((Object[])this.execSqlQuery("select count(*) from TEST where TYPE = 2").get(0))[0];
    }

    protected Integer getCountWithType3() throws Exception {
        return (Integer)((Object[])this.execSqlQuery("select count(*) from TEST where TYPE = 3").get(0))[0];
    }
}

