/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.store;

import java.io.Serializable;
import org.apache.commons.dbutils.QueryRunner;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.store.ObjectStore;
import org.mule.config.spring.SpringXmlConfigurationBuilder;
import org.mule.transport.jdbc.store.JdbcObjectStore;
import org.mule.util.store.AbstractObjectStoreContractTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcObjectStoreTestCase
extends AbstractObjectStoreContractTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcObjectStoreTestCase.class);

    public JdbcObjectStoreTestCase() {
        this.setStartContext(true);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        JdbcObjectStore store = (JdbcObjectStore)muleContext.getRegistry().get("jdbcObjectStore");
        QueryRunner qr = store.getJdbcConnector().getQueryRunner();
        try {
            qr.update(store.getJdbcConnector().getConnection(), "DELETE FROM IDS");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            qr.update(store.getJdbcConnector().getConnection(), "CREATE TABLE IDS(K VARCHAR(255) NOT NULL PRIMARY KEY, VALUE VARCHAR(255))");
        }
        catch (Exception exception) {
            // empty catch block
        }
        LOGGER.debug("Table created");
    }

    public ObjectStore getObjectStore() {
        JdbcObjectStore store = (JdbcObjectStore)muleContext.getRegistry().get("jdbcObjectStore");
        return store;
    }

    public Serializable getStorableValue() {
        return "1";
    }

    protected String getConfigurationResources() {
        return "jdbc-connector.xml,jdbc-store.xml";
    }

    protected ConfigurationBuilder getBuilder() throws Exception {
        return new SpringXmlConfigurationBuilder(this.getConfigurationResources());
    }
}

