/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet.jetty;

import java.io.InputStream;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.xml.XmlConfiguration;
import org.mule.api.MuleException;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.transport.MessageReceiver;
import org.mule.api.transport.ReplyToHandler;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.AbstractConnector;
import org.mule.transport.servlet.jetty.JettyContinuationsReceiverServlet;
import org.mule.transport.servlet.jetty.JettyContinuationsReplyToHandler;
import org.mule.transport.servlet.jetty.JettyReceiverServlet;
import org.mule.util.IOUtils;

public class JettyHttpConnector
extends AbstractConnector {
    public static final String JETTY = "jetty";
    public static final String REST = "rest";
    private Server httpServer;
    private Map serverPorts;
    private String configFile;
    private JettyReceiverServlet receiverServlet;
    private Class servletClass;
    private ServletHolder holder;
    private boolean useContinuations = false;

    public JettyHttpConnector() {
        this.registerSupportedProtocol("http");
        this.registerSupportedProtocol(JETTY);
        this.registerSupportedProtocol(REST);
        this.serverPorts = new HashMap(4);
    }

    public String getProtocol() {
        return JETTY;
    }

    protected void doInitialise() throws InitialisationException {
        this.httpServer = new Server();
        if (this.getReceiverServlet() == null) {
            this.setServletClass(this.useContinuations ? JettyContinuationsReceiverServlet.class : JettyReceiverServlet.class);
        }
        Context root = new Context((HandlerContainer)this.httpServer, "/", 1);
        this.holder = root.addServlet(this.getServletClass(), "/*");
        root.addEventListener((EventListener)new ServletContextListener(){

            public void contextInitialized(ServletContextEvent sce) {
                sce.getServletContext().setAttribute("mule.context", (Object)JettyHttpConnector.this.muleContext);
            }

            public void contextDestroyed(ServletContextEvent sce) {
            }
        });
        if (this.configFile != null) {
            try {
                InputStream is = IOUtils.getResourceAsStream((String)this.configFile, ((Object)((Object)this)).getClass());
                XmlConfiguration config = new XmlConfiguration(is);
                config.configure((Object)this.httpServer);
            }
            catch (Exception e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    protected void doDispose() {
        try {
            this.httpServer.stop();
        }
        catch (Exception e) {
            this.logger.error((Object)"Error disposing Jetty server", (Throwable)e);
        }
        this.serverPorts.clear();
    }

    protected void doStart() throws MuleException {
        try {
            this.httpServer.start();
            this.receiverServlet = (JettyReceiverServlet)this.holder.getServlet();
            for (MessageReceiver receiver : this.receivers.values()) {
                this.receiverServlet.addReceiver(receiver);
            }
        }
        catch (Exception e) {
            throw new LifecycleException(CoreMessages.failedToStart((String)"Jetty Http Receiver"), (Throwable)e, (Object)this);
        }
    }

    protected void doStop() throws MuleException {
        try {
            for (MessageReceiver receiver : this.receivers.values()) {
                this.receiverServlet.removeReceiver(receiver);
            }
            this.httpServer.stop();
        }
        catch (Exception e) {
            throw new LifecycleException(CoreMessages.failedToStop((String)"Jetty Http Receiver"), (Throwable)e, (Object)this);
        }
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    void registerListener(MessageReceiver receiver) throws Exception {
        EndpointURI uri = receiver.getEndpointURI();
        if (this.serverPorts.keySet().contains(new Integer(uri.getPort()))) {
            this.logger.debug((Object)("Http server already listening on: " + uri.getPort()));
            this.receiverServlet.addReceiver(receiver);
            return;
        }
        org.mortbay.jetty.AbstractConnector cnn = this.createJettyConnector();
        cnn.setPort(uri.getPort());
        this.httpServer.addConnector((Connector)cnn);
        this.serverPorts.put(new Integer(uri.getPort()), null);
        this.receiverServlet.addReceiver(receiver);
        cnn.start();
    }

    protected org.mortbay.jetty.AbstractConnector createJettyConnector() {
        return new SelectChannelConnector();
    }

    public boolean unregisterListener(MessageReceiver receiver) {
        return this.receiverServlet.removeReceiver(receiver);
    }

    public Server getHttpServer() {
        return this.httpServer;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public JettyReceiverServlet getReceiverServlet() {
        return this.receiverServlet;
    }

    public void setReceiverServlet(JettyReceiverServlet receiverServlet) {
        this.receiverServlet = receiverServlet;
    }

    protected JettyReceiverServlet createReceiverServlet() {
        return new JettyReceiverServlet();
    }

    public Class getServletClass() {
        return this.servletClass;
    }

    public void setServletClass(Class servletClass) {
        this.servletClass = servletClass;
    }

    public ReplyToHandler getReplyToHandler() {
        if (this.isUseContinuations()) {
            return new JettyContinuationsReplyToHandler(this.getDefaultResponseTransformers(), this.muleContext);
        }
        return super.getReplyToHandler();
    }

    public boolean isUseContinuations() {
        return this.useContinuations;
    }

    public void setUseContinuations(boolean useContinuations) {
        this.useContinuations = useContinuations;
    }
}

