/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import javax.jms.Destination;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.commons.lang.ObjectUtils;
import org.mule.config.i18n.Message;
import org.mule.impl.model.AbstractComponent;
import org.mule.providers.DefaultReplyToHandler;
import org.mule.providers.jms.Jms102bSupport;
import org.mule.providers.jms.JmsConnector;
import org.mule.providers.jms.JmsMessageUtils;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.StringMessageUtils;

public class JmsReplyToHandler
extends DefaultReplyToHandler {
    private JmsConnector connector;

    public JmsReplyToHandler(JmsConnector connector, UMOTransformer transformer) {
        super(transformer);
        this.connector = connector;
    }

    public void processReplyTo(UMOEvent event, UMOMessage returnMessage, Object replyTo) throws UMOException {
        Destination replyToDestination = null;
        MessageProducer replyToProducer = null;
        Session session = null;
        try {
            if (replyTo instanceof Destination) {
                replyToDestination = (Destination)replyTo;
            }
            if (replyToDestination == null) {
                super.processReplyTo(event, returnMessage, replyTo);
                return;
            }
            Object payload = returnMessage.getPayload();
            if (this.getTransformer() != null) {
                this.getTransformer().setEndpoint((UMOImmutableEndpoint)this.getEndpoint(event, "jms://temporary"));
                if (this.getTransformer().isSourceTypeSupported(payload.getClass())) {
                    payload = this.getTransformer().transform(payload);
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("transformer for replyTo Handler: " + this.getTransformer().toString() + " does not support source type: " + payload.getClass() + ". Not doing a transform"));
                }
            }
            if (replyToDestination instanceof Topic && replyToDestination instanceof Queue && this.connector.getJmsSupport() instanceof Jms102bSupport) {
                logger.error((Object)StringMessageUtils.getBoilerPlate((String)"ReplyTo destination implements both Queue and Topic while complying with JMS 1.0.2b specification. Please report your application server or JMS vendor name and version to dev<_at_>mule.codehaus.org or http://mule.mulesource.org/jira"));
            }
            boolean topic = replyToDestination instanceof Topic;
            session = this.connector.getSession(false, topic);
            javax.jms.Message replyToMessage = JmsMessageUtils.toMessage(payload, session);
            replyToMessage.setJMSReplyTo(null);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sending jms reply to: " + replyToDestination + "(" + replyToDestination.getClass().getName() + ")"));
            }
            replyToProducer = this.connector.getJmsSupport().createProducer(session, replyToDestination, topic);
            UMOMessage eventMsg = event.getMessage();
            String ttlString = (String)eventMsg.removeProperty("timeToLive");
            String priorityString = (String)eventMsg.removeProperty("priority");
            String persistentDeliveryString = (String)eventMsg.removeProperty("persistentDelivery");
            if (ttlString == null && priorityString == null && persistentDeliveryString == null) {
                this.connector.getJmsSupport().send(replyToProducer, replyToMessage, topic);
            } else {
                long ttl = 0L;
                int priority = 4;
                boolean persistent = true;
                if (ttlString != null) {
                    ttl = Long.parseLong(ttlString);
                }
                if (priorityString != null) {
                    priority = Integer.parseInt(priorityString);
                }
                if (persistentDeliveryString != null) {
                    persistent = Boolean.valueOf(persistentDeliveryString);
                }
                this.connector.getJmsSupport().send(replyToProducer, replyToMessage, persistent, priority, ttl, topic);
            }
            logger.info((Object)("Reply Message sent to: " + replyToDestination));
            ((AbstractComponent)event.getComponent()).getStatistics().incSentReplyToEvent();
            this.connector.closeQuietly(replyToProducer);
            this.connector.closeQuietly(session);
        }
        catch (Exception e) {
            throw new DispatchException(new Message("jms", 8, (Object)ObjectUtils.toString((Object)replyToDestination, (String)"null")), returnMessage, null, (Throwable)e);
        }
        finally {
            this.connector.closeQuietly(replyToProducer);
            this.connector.closeQuietly(session);
        }
    }
}

